package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import com.clustercontrol.ws.xcloud.AddBillingAlarmRequest;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.MonitorKind;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;
import com.clustercontrol.xcloud.ui.dialogs.CreateBillingAlarmDialog;
import com.clustercontrol.xcloud.ui.dialogs.CreateBillingAlarmDialog.DialogData;

public class AddBillingAlarmHandler extends AbstractHandler implements CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		final IHinemosManager manager = (IHinemosManager)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveHinemosManager);
		
		CreateBillingAlarmDialog dialog = new CreateBillingAlarmDialog(HandlerUtil.getActiveShell(event), manager.getManagerName());
		
		final AddBillingAlarmRequest request = new AddBillingAlarmRequest();
		dialog.setDialogDataFactory(new CreateBillingAlarmDialog.DialogDataFactory() {
			@Override
			public DialogData createDialogData() {
				return new CreateBillingAlarmDialog.DialogData() {
					@Override
					public String getAlarmId() {
						return request.getAlarmId();
					}
					@Override
					public void setAlarmId(String value) {
						request.setAlarmId(value);
					}
					@Override
					public String getAlarmName() {
						return request.getAlarmName();
					}
					@Override
					public void setAlarmName(String value) {
						request.setAlarmName(value);
					}
					@Override
					public String getDescription() {
						return request.getDescription();
					}
					@Override
					public void setDescription(String value) {
						request.setDescription(value);
					}
					@Override
					public String getFacilityId() {
						return request.getFacilityId();
					}
					@Override
					public void setFacilityId(String value) {
						request.setFacilityId(value);
					}
					@Override
					public MonitorKind getMonitorKind() {
						return request.getMonitorKind();
					}
					@Override
					public void setMonitorKind(MonitorKind value) {
						request.setMonitorKind(value);
					}
					@Override
					public List<NotifyRelationInfo> getNotifyRelationInfos() {
						return request.getNotifyRelationInfos();
					}
					@Override
					public void setNotifyRelationInfos(List<NotifyRelationInfo> value) {
						request.getNotifyRelationInfos().clear();
						request.getNotifyRelationInfos().addAll(value);
					}
					@Override
					public Double getThresholdInfoLimit() {
						return request.getThresholdInfoLimit();
					}
					@Override
					public void setThresholdInfoLimit(Double value) {
						request.setThresholdInfoLimit(value);
					}
					@Override
					public Double getThresholdWarnLimit() {
						return request.getThresholdWarnLimit();
					}
					@Override
					public void setThresholdWarnLimit(Double value) {
						request.setThresholdWarnLimit(value);
					}
					@Override
					public Boolean getValidFlg() {
						return request.isValidFlg();
					}
					@Override
					public void setValidFlg(Boolean value) {
						request.setValidFlg(value);
					}
					@Override
					public String getOwnerRoleId() {
						return request.getOwnerRoleId();
					}
					@Override
					public void setOwnerRoleId(String value) {
						request.setOwnerRoleId(value);
					}
					@Override
					public Boolean getCollectFlg() {
						return request.isCollectFlg();
					}
					@Override
					public void setCollectFlg(Boolean value) {
						request.setCollectFlg(value);
					}
				};
			}
		});
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					MessageFormat.format(msgConfirmCreateBilligAlarm, request.getAlarmName(), request.getAlarmId()))) {
				
				try {
					CloudEndpoint endpoint = manager.getEndpoint(CloudEndpoint.class);
					endpoint.addBillingAlarm(request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishCreateBilligAlarm, request.getAlarmName(), request.getAlarmId()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							manager.getBillingAlarms().updateBillingAlarms();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);
		
					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
