/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.ui.views;

import static com.clustercontrol.xcloud.common.CloudConstants.bundle_messages;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.base.ElementBaseModeWatch;
import com.clustercontrol.xcloud.model.base.IElement;
import com.clustercontrol.xcloud.model.cloud.IBillingAlarm;
import com.clustercontrol.xcloud.model.cloud.IBillingAlarms;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.util.TableViewerSorter;

/**
 */
public class BillingAlarmsView extends AbstractCloudViewPart {
	public static final String Id = BillingAlarmsView.class.getName();
	
	protected ElementBaseModeWatch.AnyPropertyWatcher watcher = new Watcher<IBillingAlarm>(){
		@Override protected void asyncRefresh() {
			BillingAlarmsView.this.refresh();
		}
		@Override
		protected void unwatchedOwner(IElement owning, IElement owned) {
			currentBillingAlarms = null;
			tableViewer.setInput(null);
		}
	};
	
	protected ISelectionListener selectionListener = new ISelectionListener() {
		@Override
		public void selectionChanged(IWorkbenchPart part, ISelection selection) {
			if (!part.getSite().getId().equals(CloudScopesView.Id))
				return;
			refresh(selection);
		}
	};
	
	private Table table;
	private TableViewer tableViewer;
	private Label lblFooder;
	
	private IBillingAlarms currentBillingAlarms;
	
//	private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");

	private enum ViewColumn{
		billingalarm_id(
			bundle_messages.getString("word.alarm_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IBillingAlarm)element).getId();
				}
			}
		),
		billingalarm_name(
			bundle_messages.getString("word.alarm_name"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IBillingAlarm)element).getName();
				}
			}
		),
		description(
			bundle_messages.getString("word.description"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IBillingAlarm)element).getDescription();
				}
			}
		),
		owner_role_id(
			bundle_messages.getString("word.owner_role_id"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IBillingAlarm)element).getOwnerRoleId();
				}
			}
		),
		facility_id(
				bundle_messages.getString("word.facility_id"),
				new ColumnPixelData(100, true, true),
				new ColumnLabelProvider(){
					@Override
					public String getText(Object element) {
						return ((IBillingAlarm)element).getFacilityId();
					}
				}
			),
		type(
			bundle_messages.getString("word.type"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					switch (((IBillingAlarm)element).getMonitorKind()) {
					case DELTA:
						return bundle_messages.getString("word.delta");
					case SUM:
						return bundle_messages.getString("word.sum");
					}
					return "";
				}
			}
		),
		valid_flag(
			bundle_messages.getString("word.valid_flag"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if (Boolean.TRUE.equals(((IBillingAlarm)element).getValidFlg())) {
						return bundle_messages.getString("word.enable");
					}
					else {
						return bundle_messages.getString("word.disable");
					}
				}
			}
		),
		reg_date(
			bundle_messages.getString("word.reg_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((IBillingAlarm)element).getRegDate() != null){
						return format.format(((IBillingAlarm)element).getRegDate());
					}
					return "";
				}
			}
		),
		reg_user(
			bundle_messages.getString("word.reg_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IBillingAlarm)element).getRegUser();
				}
			}
		),
		update_date(
			bundle_messages.getString("word.update_date"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					if(((IBillingAlarm)element).getUpdateDate() != null){
						return format.format(((IBillingAlarm)element).getUpdateDate());
					}
					return "";
				}
			}
		),
		update_user(
			bundle_messages.getString("word.update_user"),
			new ColumnPixelData(100, true, true),
			new ColumnLabelProvider(){
				@Override
				public String getText(Object element) {
					return ((IBillingAlarm)element).getUpdateUser();
				}
			}
		);

		private String label;
		private ColumnLabelProvider provider;
		private ColumnPixelData pixelData;
		private static SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
		
		ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider){
			this.label = label;
			this.pixelData = pixelData;
			this.provider = provider;
		}

		public String getLabel() {
			return label;
		}

		public ColumnPixelData getPixelData() {
			return pixelData;
		}

		public ColumnLabelProvider getProvider() {
			return provider;
		}
	}

 	public BillingAlarmsView() {
 		super();
	}

	@Override
	protected void internalCreatePartControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		TableColumnLayout tcl_composite_1 = new TableColumnLayout();
		composite_1.setLayout(tcl_composite_1);

		tableViewer = new TableViewer(composite_1, SWT.BORDER | SWT.FULL_SELECTION | SWT.MULTI);
		table = tableViewer.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		for(final ViewColumn column: ViewColumn.values()){
			TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
			TableColumn tableColumn = tableViewerColumn.getColumn();
			tcl_composite_1.setColumnData(tableColumn, column.getPixelData());
			tableColumn.setText(column.getLabel());
			tableViewerColumn.setLabelProvider(column.getProvider());
			tableColumn.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					tableViewer.setSorter(new TableViewerSorter(tableViewer, column.getProvider()));
				}
			});
		}
		
		GridLayout gl_composite = new GridLayout(1, true);
		gl_composite.horizontalSpacing = 0;
		gl_composite.marginHeight = 0;
		gl_composite.marginWidth = 0;
		gl_composite.verticalSpacing = 0;
		composite.setLayout(gl_composite);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		composite_1.setLayoutData(gridData);

		lblFooder = new Label(composite, SWT.NONE);
		lblFooder.setAlignment(SWT.RIGHT);
		lblFooder.setSize(lblFooder.getSize().x, 80);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		lblFooder.setLayoutData(gridData);

		tableViewer.setContentProvider(new ArrayContentProvider());
		tableViewer.setComparator(new ViewerComparator(){
			// Set sorting key by element type
			private String getSortingKey(Object element){
				return (element instanceof IBillingAlarm)? ((IBillingAlarm)element).getId(): "";
			}

			@Override
			public int compare(Viewer viewer, Object e1, Object e2) {
				return getSortingKey(e1).compareTo(getSortingKey(e2));
			}
		});

		getSite().setSelectionProvider(tableViewer);
		
		getSite().getPage().addSelectionListener(CloudScopesView.Id, selectionListener);
	}
	
	@Override
	public void dispose() {
		if (currentBillingAlarms != null)
			currentBillingAlarms.getHinemosManager().getModelWatch().removeWatcher(currentBillingAlarms, watcher);

		getSite().getPage().removeSelectionListener(CloudScopesView.Id, selectionListener);
		getSite().setSelectionProvider(null);
		super.dispose();
	}

	@Override
	protected StructuredViewer getViewer() {
		return tableViewer;
	}

	@Override
	public String getId() {
		return Id;
	}
	
	@Override
	public void update() {
		if (currentBillingAlarms != null) {
			try {
				currentBillingAlarms.updateBillingAlarms();
			} catch (CloudModelException e) {
				Logger.getLogger(this.getClass()).warn(e.getMessage(), e);
				currentBillingAlarms = null;
			}
		}
	}

	protected void refresh() {
		refresh(getSite().getPage().getSelection(CloudScopesView.Id));
	}

	protected void refresh(ISelection selection) {
		if (currentBillingAlarms != null) {
			try {
				currentBillingAlarms.getHinemosManager().getModelWatch().removeWatcher(currentBillingAlarms, watcher);
			} catch (CloudModelException e) {
				Logger.getLogger(this.getClass()).warn(e.getMessage(), e);
			}
		}

		currentBillingAlarms = null;

		List<IBillingAlarm> alarms = new ArrayList<>();
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection sselection = (IStructuredSelection)selection;
			if (!sselection.isEmpty()) {
				Object selected = sselection.getFirstElement();
				if (selected instanceof IElement) {
					currentBillingAlarms = ((IHinemosManager)((IElement)selected).getAdapter(IHinemosManager.class)).getBillingAlarms();
				}
				
				if (currentBillingAlarms != null) {
					alarms = Arrays.asList(currentBillingAlarms.getBillingAlarmsWithInitializing());

					try {
						currentBillingAlarms.getHinemosManager().getModelWatch().addWatcher(currentBillingAlarms, watcher);
					} catch (CloudModelException e) {
						Logger.getLogger(this.getClass()).warn(e.getMessage(), e);
					}
				} else {
					currentBillingAlarms = null;
				}
			}
		}
		
		tableViewer.setInput(alarms);
		getViewSite().getActionBars().updateActionBars();
		getViewSite().getActionBars().getToolBarManager().update(false);
//		lblFooder.setText(footerTitle + billingAlarms.size());
	}
}