<?php
/**
 *	Calendar.php
 *
 *	@author		your name
 *	@package	Xanhte
 *	@version 	$Id: app.action.default.php,v 1.9 2004/12/14 07:23:12 fujimoto Exp $
 */

/**
 *	եμ
 *  unserializeʸ֤ޤ
 *	@author		your name
 *	@access		public
 *	@package	Xanhte
 */
require_once XANHTE_ROOT_PATH.'/app/action/Blocks.php';
class Xanhte_Form_BlocksXeblogCalendar extends Xanhte_Form_Blocks
{
	var $form = array(
		'options' => array(
			'name' => '֥åץ',
			'required' => false,
			'form_type'=> FORM_TYPE_TEXT,
			'type'          => array(VAR_TYPE_STRING),
			),
		'dirname' => array(
			'name'			=> 'ǥ쥯ȥ̾',
			'required'      => false,
			'form_type'		=> FORM_TYPE_TEXT,
			'type'          => VAR_TYPE_STRING,
			'regexp' => '/^\w+$/',
			),
		'caldate' => array(
			'name'			=> '',
			'required'      => false,
			'form_type'		=> FORM_TYPE_TEXT,
			'type'          => VAR_TYPE_STRING,
			'regexp' => '/^\d{4}(-\d{1,2})?(-\d{1,2})?$/', // YYYY-MM-DD
			),
		'user_id' => array(
			'name'			=> '桼ID',
			'required'      => false,
			'form_type'		=> FORM_TYPE_TEXT,
			'type'          => VAR_TYPE_INT,
			),
		'cat_id' => array(
			'name'			=> 'ƥID',
			'required'      => false,
			'form_type'		=> FORM_TYPE_TEXT,
			'type'          => VAR_TYPE_INT,
			),
		);
}

/**
 *	searchμ
 *
 *	@author		your name
 *	@access		public
 *	@package	Xanhte
 */
class Xanhte_Action_BlocksXeblogCalendar extends Xanhte_Action_Blocks
{
	/**
	 *	Notification
	 *
	 *	@access	public
	 *	@return	string		Forward(ｪλʤnull)
	 */
	function prepare()
	{
		return parent::prepare(); // $options$dirnameγ
	}

	/**
	 *	Notificationμ
	 *
	 *	@access	public
	 *	@return	string	̾
	 */
	function perform()
	{
		$block = array();
		global $xoopsConfig ;
		$this->notification->backupGLOBALS();

		$options = $this->af->get('options');
		$dirname = $this->af->get('dirname');
		
		global $xoopsConfig, $xoopsTpl,$xoopsUser;
		define('DATE_CALC_BEGIN_WEEKDAY', intval($options[0]));
		require_once XANHTE_ROOT_PATH . '/lib/Date/Calc.php' ;

		// set when month
		$date = $this->af->get('caldate');
		if($date){
			list($this_year,$this_month,$this_day) = sscanf($date, '%d-%d-%d');
			$this_year = is_null($this_year) ? date('Y') : sprintf('%04s', $this_year);
			$this_month = is_null($this_month) ? date('m') : sprintf('%02s', $this_month);
			$this_day = is_null($this_day) ? '' : sprintf('%02s', $this_day);
		}else{
			list($this_year, $this_month , $this_day) = explode('-', date('Y-m-')) ;
		}
//		$fp = fopen('/tmp/date_calc.log','a+');
//		fputs($fp,$this_year.$this_month.$this_day."\n");
		
		// get next/previous month and year
		$block['dateinfo'] = array(
			'this_year' => $this_year,
			'this_month' => $this_month,
			'next_year' => strval($this_year + 1) .'-'. $this_month ,
			'next_month' => Date_Calc::beginOfNextMonth('1',$this_month,$this_year,$format='%Y-%m') ,
			'prev_year' => strval($this_year - 1) .'-'. $this_month ,
			'prev_month' => Date_Calc::beginOfPrevMonth('1',$this_month,$this_year,$format='%Y-%m') ,
		
		);
		
		if (file_exists(XOOPS_ROOT_PATH.'/language/'.$xoopsConfig["language"].'/calendar.php')) {
			require_once(XOOPS_ROOT_PATH.'/language/'.$xoopsConfig["language"].'/calendar.php');
		} else {
			require_once(XOOPS_ROOT_PATH.'/language/english/calendar.php');
		}
		
		$month_arr = array(1 => _CAL_JANUARY, 2 => _CAL_FEBRUARY, 3 => _CAL_MARCH, 4 => _CAL_APRIL,
						   5 => _CAL_MAY, 6 => _CAL_JUNE, 7 => _CAL_JULY, 8 => _CAL_AUGUST,
						   9 => _CAL_SEPTEMBER, 10 => _CAL_OCTOBER, 11 => _CAL_NOVEMBER, 12 => _CAL_DECEMBER
						   );
		// ٥Ĵ
		$week_arr = array( array('sunday'=>_MB_XEBLOG_LANG_SUNDAY), array('monday'=>_MB_XEBLOG_LANG_MONDAY),
						   array('tuesday'=>_MB_XEBLOG_LANG_TUESDAY),  array('wednesday'=>_MB_XEBLOG_LANG_WEDNESDAY),
						   array('thursday'=>_MB_XEBLOG_LANG_THURSDAY), array('friday'=>_MB_XEBLOG_LANG_FRIDAY),
						   array('saturday'=>_MB_XEBLOG_LANG_SATURDAY) );
		$weekinfo = array();
		$start_week = $options[0];
		for($i=0; $i<7; $i++){
			list($cssclass,$label) = each($week_arr[($start_week + $i)%7]) ;
			$weekinfo[] = array('cssclass'=> $cssclass , 'label'=> $label);
		}
		
		// 
		$monthlyCalendar = Date_Calc::getCalendarMonth($this_month, $this_year) ;
		// դΥȥ
		$entriesDay = $this->xeblogE->getListOfEntryMonth(sprintf('%04s%02s',$this_year,$this_month)) ;
		// ˾տ
		foreach($monthlyCalendar as $week=>$dayArray){
			foreach($dayArray as $key=>$day){
				// cssѤΥ饹
				if(strcmp(substr($day,0,6), sprintf('%04s%02s',$this_year,$this_month)) ){
					$cssclass = 'xeblogOtherMonth';
				}elseif(!strcmp($day,$this->af->get('caldate'))){
					$cssclass = 'xeblogToday';
				}else{
					switch($key){
					  case 0 :
						$cssclass = 'xeblogSunday';	break ;
					  case 6 :
						$cssclass = 'xeblogSaturday'; break;
					  default :
						$cssclass = 'xeblogWeekday';
					}
				}
				$monthlyCalendar[$week][$key] = array(
					'hasEntry'=>isset($entriesDay[$day]) ? true : false ,
					'cssclass'=> $cssclass ,
					'day' => intval(substr($day,6,2)),
					);
			}
		}
		// 
		$block['cal'] = $monthlyCalendar ;
		$block['weekinfo'] = $weekinfo;
		$block['user_id'] = $this->af->get('user_id');
		$block['cat_id'] = $this->af->get('cat_id');
		$this->af->setAppNe('result', serialize($block));
		$this->notification->restoreGLOBALS();
		
		// add xoops_block_header for css file
		global $xoopsTpl;
		$xoops_module_header = $xoopsTpl->get_template_vars('xoops_module_header');
		$xoops_module_header .= sprintf('<link rel="stylesheet" type="text/css" media="screen" href="%s/modules/%s/css/block_calendar.css" />',XOOPS_URL,$this->af->get('dirname'));
		$xoopsTpl->assign('xoops_module_header', $xoops_module_header);	
		return 'blocks';
	}

}
?>
