// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    HOS_IDL_STK API ν                                                  
//                                                                            
//                                    Copyright (C) 1998-2003 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "idlstk.h"
#include "analyze.h"


#define IDLSTK_STKSZ		0
#define IDLSTK_STK			1


// 󥹥ȥ饯
CApiIdleStack::CApiIdleStack()
{
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParams = 2;
}


// ǥȥ饯
CApiIdleStack::~CApiIdleStack()
{
}


// ưIDֹ
int CApiIdleStack::AutoId(void)
{
	return CFG_ERR_OK;
}


// APIβ
int CApiIdleStack::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	if ( strcmp(pszApiName, "HOS_IDL_STK") == 0 )
	{
		if ( m_iObjs > 0 )
		{
			return CFG_ERR_MULTIDEF;
		}

		return AddParams(pszParams);
	}

	return CFG_ERR_NOPROC;
}


// cfgե񤭽Ф
void  CApiIdleStack::WriteCfgDef(FILE* fp)
{
	const char* pszSize;
	const char* pszStack;

	// Ƚ
	fputs(
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*                 idle stack                 */\n"
		"/* ------------------------------------------ */\n\n"
		, fp);

	// ѥ᡼ɤ߽Ф
	if ( m_iObjs > 0 )
	{
		pszSize  = m_pParamPacks[0]->GetParam(IDLSTK_STKSZ);
		pszStack = m_pParamPacks[0]->GetParam(IDLSTK_STK);
	}
	else
	{
		pszSize  = "128";		// ̵꤬Хǥեȥ
		pszStack = "NULL";		// ̵꤬NULL(ư)
	}

	// ɥ롼ѥå
	if ( strcmp(pszStack, "NULL") == 0 )
	{
		fprintf(
			fp,
			"VP         mknl_idl_stkblk[((%s) + sizeof(VP) - 1) / sizeof(VP)];\t/* idle stack block*/\n"
			"const VP   mknl_idl_stk   = (VP)(mknl_idl_stkblk);\t/* idle stack */\n"
			"const SIZE mknl_idl_stksz = (SIZE)sizeof(mknl_idl_stkblk);\t/* idle stack size */\n",
			pszSize);
	}
	else
	{
		fprintf(
			fp,
			"const VP   mknl_idl_stk   = (VP)(%s);\t/* idle stack */\n"
			"const SIZE mknl_idl_stksz = (SIZE)(%s);\t/* idle stack */\n",
			pszStack,pszSize);
	}
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2003 by Project HOS                                    
// ---------------------------------------------------------------------------
