/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå Ĺס                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mpf_h__
#define __HOS_V4__knl_mpf_h__


#include "knl_hos.h"
#include "knl_mem.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_MPFID	TMIN_MPFID			/* ĹסIDκǾ */
#define KERNEL_TMAX_MPFID	(KERNEL_TMIN_MPFID + kernel_mpfcb_cnt - 1)
												/* ĹסIDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* Ĺס */
typedef struct t_cmpf
{
	ATR  mpfatr;		/* Ĺס° */
	UINT blkcnt;		/* Ǥ֥å(Ŀ) */
	UINT blksz;			/* ֥åΥ(Хȿ) */
	VP   mpf;			/* ĹסΰƬ */
} T_CMPF;

/* Ĺס */
typedef struct t_rmpf
{
	ID   wtskid;		/* ĹסԤƬΥIDֹ */
	UINT fblkcnt;		/* Ĺסζ֥å(Ŀ) */
} T_RMPF;


/* Ĺס륳ȥ֥å(ROM) */
typedef struct t_kernel_mpfcb_rom
{
	ATR  mpfatr;		/* Ĺס° */
	UINT blkcnt;		/* Ǥ֥å(Ŀ) */
	UINT blksz;			/* ֥åΥ(Хȿ) */
	VP   mpf;			/* ĹסΰƬ */
} T_KERNEL_MPFCB_ROM;


/* Ĺס륳ȥ֥å(RAM) */
typedef struct t_kernel_mpfcb_ram
{
	T_MKNL_QUE que;		/* ĹסԤ塼 */
	VP         free;	/* ֥åؤΥݥ */
	const T_KERNEL_MPFCB_ROM *mpfcb_rom;	/* Ĺס륳ȥ֥åROMؤΥݥ */
} T_KERNEL_MPFCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* Ĺס */
extern       T_KERNEL_MPFCB_RAM *kernel_mpfcb_ram_tbl[];	/* Ĺס륳ȥ֥åơ֥(RAM) */
extern const INT kernel_mpfcb_cnt;							/* Ĺס륳ȥ֥åĿ */

/* ---------------------------------- */
/*            ޥ              */
/* ---------------------------------- */
/* Ĺס륳ȥ֥åѴޥ */
#define KERNEL_MPFID_TO_MPFCB_RAM(mpfid)	(kernel_mpfcb_ram_tbl[(mpfid) - KERNEL_TMIN_MPFID])
															/* ĹסIDMPFCB RAMɥ쥹 */
/* סΰΥ */
#define TSZ_MPF(blkcnt,blksz)	((SIZE)((blkcnt) * TSZ_ALIGNED(blksz)))



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* Ĺס */
void    kernel_ini_mpf(void);								/* Ĺסν */
ER      cre_mpf(ID mpfid, const T_CMPF *pk_cmpf);			/* Ĺס */
ER_ID   acre_mpf(const T_CMPF *pk_cmpf);					/* Ĺס(IDֹ漫ưդ) */
ER      kernel_cre_mpf(ID mpfid, const T_CMPF *pk_cmpf);	/* Ĺס(ͥؿ) */
ER      del_mpf(ID mpfid);									/* Ĺסκ */
ER      get_mpf(ID mpfid, VP *p_blk);						/* Ĺ֥åγ */
ER      pget_mpf(ID mpfid, VP *p_blk);						/* Ĺ֥åγ(ݡ) */
ER      tget_mpf(ID mpfid, VP *p_blk, TMO tmout);			/* Ĺ֥åγ(ॢȤ) */
ER      rel_mpf(ID mpfid, VP blk);							/* Ĺ֥åֵ */
ER      ref_mpf(ID mpfid, T_RMPF *pk_rmpf);					/* Ĺ֥åξֻ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_mpf_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
