/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå Ĺס                         */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_mpl_h__
#define __HOS_V4__knl_mpl_h__


#include "knl_hos.h"
#include "knl_hep.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_MPLID	TMIN_MPLID			/* ĹסIDκǾ */
#define KERNEL_TMAX_MPLID	(KERNEL_TMIN_MPLID + kernel_mplcb_cnt - 1)
												/* ĹסIDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* Ĺס */
typedef struct t_cmpl
{
	ATR  mplatr;		/* Ĺס° */
	UINT mplsz;			/* ĹסΰΥ(Хȿ) */
	VP   mpl;			/* ĹסΰƬ */
} T_CMPL;

/* Ĺס */
typedef struct t_rmpl
{
	ID   wtskid;		/* ĹסԤƬΥIDֹ */
	SIZE fmplsz;		/* Ĺסζΰιץ(Хȿ) */
	UINT fblksz;		/* ˳ǽʺ֥å(Хȿ) */
} T_RMPL;


/* Ĺס륳ȥ֥å(ROM) */
typedef struct t_kernel_mplcb_rom
{
	ATR  mplatr;		/* Ĺס° */
	UINT mplsz;			/* ĹסΰΥ(Хȿ) */
	VP   mpl;			/* ĹסΰƬ */
} T_KERNEL_MPLCB_ROM;


/* Ĺס륳ȥ֥å(RAM) */
typedef struct t_kernel_mplcb_ram
{
	T_MKNL_QUE     que;	/* ĹסԤ塼 */
	T_KERNEL_HEPCB hep;	/* ҡ */
	const T_KERNEL_MPLCB_ROM *mplcb_rom;	/* Ĺס륳ȥ֥åROMؤΥݥ */
} T_KERNEL_MPLCB_RAM;


/* Ԥ¤ */
typedef struct t_kernel_mplinf
{
	UINT blksz;			/* ֥åΥ(Хȿ) */
	VP   *p_blk;		/* ֥åƬ */
} T_KERNEL_MPLINF;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* Ĺס */
extern       T_KERNEL_MPLCB_RAM *kernel_mplcb_ram_tbl[];	/* Ĺס륳ȥ֥åơ֥(RAM) */
extern const INT kernel_mplcb_cnt;							/* Ĺס륳ȥ֥åĿ */


/* ---------------------------------- */
/*            ޥ              */
/* ---------------------------------- */

/* Ĺס륳ȥ֥åѴޥ */
#define KERNEL_MPLID_TO_MPLCB_RAM(mplid)	(kernel_mplcb_ram_tbl[(mplid) - KERNEL_TMIN_MPLID])
															/* ĹסIDMPLCB RAMɥ쥹 */


/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* Ĺס */
void    kernel_ini_mpl(void);								/* Ĺסν */
ER      cre_mpl(ID mplid, const T_CMPL *pk_cmpl);			/* Ĺס */
ER_ID   acre_mpl(const T_CMPL *pk_cmpl);					/* Ĺס(IDֹ漫ưդ) */
ER      kernel_cre_mpl(ID mplid, const T_CMPL *pk_cmpl);	/* Ĺס(ͥؿ) */
ER      del_mpl(ID mplid);									/* Ĺסκ */
ER      get_mpl(ID mplid, UINT blksz, VP *p_blk);			/* Ĺ֥åγ */
ER      pget_mpl(ID mplid, UINT blksz, VP *p_blk);			/* Ĺ֥åγ(ݡ) */
ER      tget_mpl(ID mplid, UINT blksz, VP *p_blk, TMO tmout);
															/* Ĺ֥åγ(ॢȤ) */
ER      rel_mpl(ID mplid, VP blk);							/* Ĺ֥åֵ */
ER      ref_mpl(ID mplid, T_RMPL *pk_rmpl);					/* Ĺ֥åξֻ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_mpl_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
