/*******************************************************************************
 * Hyper Operating System V4  ץץ
 *
 *  ƥεưȥ̾򥷥ꥢ륳󥽡ɽץ
 *      ̾    ͥ  ư
 *      Task1       1       Task2sig_sem()ˤ굯ư
 *      Task2       2       1[s]μޤˤ굯ư
 *
 *                                      Copyright (C) 1998-2007 by Project HOS
 *                                      http://sourceforge.jp/projects/hos/
 *******************************************************************************/

#include <semb1200a/semb1200a.h>
#include "semb1200a/ux_signal.h"
#include "kernel.h"
#include "kernel_id.h"
#include "sample.h"

/**
 *  mainؿ
 */
int
main(void)
{
	/* HOS-V4 γ */
	sta_hos();
	return 0;
}

/**
 *  ؿ
 *  εưԤ
 */
void
sample_init (VP_INT exinf)
{
    act_tsk (TSKID_SAMPLE_1);
    act_tsk (TSKID_SAMPLE_2);

    /* ޤεư */
    sta_cyc (CYCID_SAMPLE_1);
}

/**
 *  ץ륿1
 *  - 2ޥեޤԤ
 *  - ߻ȥ̾ɽ
 */
void
sample_task_1 (VP_INT exinf)
{
    for (;;) {
        wai_sem (SEMID_SAMPLE_1);
        sample_print (1);
    }
}

/**
 *  ץ륿2
 *  - 1[s]δsleep
 *  - ޥե
 *  - ߻ȥ̾ɽ
 */
void
sample_task_2 (VP_INT exinf)
{
    for (;;){
        slp_tsk ();
        sig_sem (SEMID_SAMPLE_1);
        sample_print (2);
    }
}

/**
 *  ߻ȥnoɽ
 */
void
sample_print (int no)
{
    SYSTIM st;

    get_tim (&st);

    uart1_putc ('0'+ (st.ltime / 10000) % 10);
    uart1_putc ('0'+ (st.ltime / 1000) % 10);
    uart1_putc ('0'+ (st.ltime / 100) % 10);
    uart1_putc ('0'+ (st.ltime / 10) % 10);
    uart1_putc ('0'+ (st.ltime / 1) % 10);
    uart1_puts (":Task ");
    uart1_putc ('0'+no);
    uart1_puts ("\n\r");
}

void
sample_cycle_handler (VP_INT exinf)
{
    iwup_tsk (TSKID_SAMPLE_2);
}
