/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"
#include "knl_sys.h"



/* ٥ȥե饰ξֻ */
ER ref_flg(					
		ID     flgid,		/* ֻоݤΥ٥ȥե饰IDֹ */
		T_RFLG *pk_rflg)	/* ٥ȥե饰֤֤ѥåȤؤΥݥ */
{
	T_KERNEL_FLGCB_RAM       *flgcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	/* ѥ᡼Υå */
#ifdef HOS_ERCHK_E_PAR
	if ( pk_rflg == NULL )
	{
		return E_PAR;	/* ѥ᡼顼 */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* ֥Ȥ¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* ٥ȥե饰ԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&flgcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rflg->wtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rflg->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* ե饰ӥåȥѥμ */
	pk_rflg->flgptn = flgcb_ram->flgptn;

	mknl_unl_sys();	/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
