/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ åХåե                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbf.h"
#include "knl_mem.h"


/* åХåեκ */
ER del_mbf(
		ID mbfid)	/* оݤΥåХåեIDֹ */
{
	T_KERNEL_MBFCB_RAM *mbfcb_ram;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mbfid < KERNEL_TMIN_MBFID || mbfid > KERNEL_TMAX_MBFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mbfcb_ram = KERNEL_MBFID_TO_MBFCB_RAM(mbfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mbfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	/* Ԥβ */
	mknl_clr_que(&mbfcb_ram->sndque);
	mknl_clr_que(&mbfcb_ram->rcvque);
	
	/* β */
	kernel_fre_mem(mbfcb_ram);
	KERNEL_MBFID_TO_MBFCB_RAM(mbfid) = NULL;
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();	/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
