/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ᡼ܥå                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mbx.h"



/* ᡼ܥå(IDֹ漫ưդ) */
ER_ID acre_mbx(
		const T_CMBX *pk_cmbx)	/* ᡼ܥå줿ѥåȤؤΥݥ */
{
	ID mbxid;
	ER ercd;

	mknl_loc_sys();	/* ƥΥå */

	/* ѲǽIDθ */
	for ( mbxid = KERNEL_TMAX_MBXID; mbxid >= KERNEL_TMIN_MBXID; mbxid-- )
	{
		if ( KERNEL_MBXID_TO_MBXCB_RAM(mbxid) == NULL )
		{
			break;
		}
	}
	
	/* IDֹ­å */
#ifdef HOS_ERCHK_E_NOID
	if ( mbxid < KERNEL_TMIN_MBXID )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOID;	/* IDֹ­ */
	}
#endif

	/* ᡼ܥå */
	ercd = kernel_cre_mbx(mbxid, pk_cmbx);
	if ( ercd != E_OK )
	{
		mknl_unl_sys();	/* ƥΥå */
		return (ER_ID)ercd;
	}
	
	mknl_unl_sys();	/* ƥΥå */

	return (ER_ID)mbxid;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
