/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"
#include "knl_sys.h"



/* Ĺ֥åξֻ */
ER ref_mpf(
		ID     mpfid,		/* ּоݤθĹסIDֹ */
		T_RMPF *pk_rmpf)	/* Ĺס֤֤ѥåȤؤΥݥ */
{
	T_KERNEL_MPFCB_RAM *mpfcb_ram;
	T_MKNL_TCB *mtcb;
	VP   blk;
	UINT blkcnt;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* ID */
	}
#endif

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rmpf == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	/* Ĺ֥åԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&mpfcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rmpf->wtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rmpf->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* ֥åΥ */
	blkcnt = 0;
	blk    = mpfcb_ram->free;
	while ( blk != NULL )
	{
		blk = *(VP *)blk;
		blkcnt++;
	}

	pk_rmpf->fblkcnt = blkcnt;
	
	mknl_unl_sys();		/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
