/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpl.h"
#include "knl_sys.h"



/* Ĺ֥åξֻ */
ER ref_mpl(
		ID     mplid,		/* ּоݤβĹסIDֹ */
		T_RMPL *pk_rmpl)	/* Ĺס֤֤ѥåȤؤΥݥ */
{
	T_KERNEL_MPLCB_RAM *mplcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mplid < KERNEL_TMIN_MPLID || mplid > KERNEL_TMAX_MPLID )
	{
		return E_ID;	/* ID */
	}
#endif

	/* ѥ᡼å */
#ifdef HOS_ERCHK_E_PAR 
	if ( pk_rmpl == NULL )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mplcb_ram = KERNEL_MPLID_TO_MPLCB_RAM(mplid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mplcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	/* Ĺ֥åԤƬΥIDֹ */
	mtcb = mknl_ref_qhd(&mplcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb == NULL )
	{
		pk_rmpl->wtskid = TSK_NONE;		/* Ԥʤ */
	}
	else
	{
		/* ID򸡺 */
		pk_rmpl->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}

	/* ֥åξ(̤) */
	
	mknl_unl_sys();		/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
