/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpl.h"



/* Ĺ֥åֵ */
ER rel_mpl(
		ID mplid,		/* ֥åоݤβĹסIDֹ */
		VP blk)			/* ֵѤ֥åƬ */
{
	T_KERNEL_MPLCB_RAM *mplcb_ram;
	T_MKNL_TCB         *mtcb;
	T_KERNEL_MPLINF    *mplinf;
	VP                 mem;
	BOOL               wup = FALSE;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mplid < KERNEL_TMIN_MPLID || mplid > KERNEL_TMAX_MPLID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mplcb_ram = KERNEL_MPLID_TO_MPLCB_RAM(mplid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mplcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* סֵ */
	kernel_fre_hep(&mplcb_ram->hep, blk);

	/* Ԥε */
	for ( ; ; )
	{
		/* ԤƬ饿Ф */
		mtcb = mknl_ref_qhd(&mplcb_ram->que);
		if ( mtcb == NULL )
		{
			break;
		}
		
		/* ݤ˥ȥ饤 */
		mplinf = (T_KERNEL_MPLINF *)mtcb->data;
		mem = kernel_alc_hep(&mplcb_ram->hep, mplinf->blksz);
		if ( mem == NULL )
		{
			break;
		}

		/* ԤԤ */
		*mplinf->p_blk = mem;
		mknl_rmv_que(mtcb);					/* סԤ󤫤 */
		mknl_rmv_tmout(mtcb);				/* ॢԤ󤫤 */
		mknl_wup_tsk(mtcb, E_OK);			/* Ԥ */
		
		wup = TRUE;
	}
	
	if ( wup )
	{
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
	}

	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
