/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ζλ */
ER ter_tsk(
		ID tskid)	/* λоݤΥIDֹ */
{						
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ID饿ȥ֥åRAM */
	tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( tcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	/* ӥѥå */
#ifdef HOS_ERCHK_E_ILUSE
	if ( mknl_get_run_tsk() == &tcb_ram->mtcb )		/* ¹Υʤ */
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_ILUSE;	/* ӥ */
	}
#endif

	/* ֥Ȥξ֥å */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )	/* Ǥ˵ٻ߾֤ʤ */
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ֥Ⱦ֥顼 */
	}
#endif

	/* ¹ԥνλ */
	mknl_rmv_tmout(&tcb_ram->mtcb);		/* ॢԤˤĤʤƤв */
	mknl_ter_tsk(&tcb_ram->mtcb);		/*  */

	/* ư塼󥰤Ƥʤ */
	if ( tcb_ram->actcnt > 0 )
	{
		tcb_rom = tcb_ram->tcb_rom;

		tcb_ram->actcnt--;	/* 塼󥰸 */

		/* ¹ԥƥϿ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* Ͽ륿 */
				tcb_rom->exinf,			/* γĥ */
				(FP)kernel_task_entry,	/* εư */
				tcb_rom->itskpri,		/* εưͥ */
				tcb_rom->stksz,			/* Υåΰ襵 */
				tcb_rom->stk			/* ΥåΰƬ */
			);	
		tcb_ram->suscnt = 0;	/* Ԥͥȥꥢ */
		tcb_ram->wupcnt = 0;	/* Ԥ׵ᥭ塼󥰥ꥢ */
	}
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();	/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
