#include "mipsregs.h"

#define SF_SIZE (4*72)        
/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (MIPS4ߴ)                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */
                .global hospac_dis_int         /* ߶ػ */
                .global hospac_ena_int         /* ߵ */
                .global hospac_cre_ctx_asm     /* ¹ԥƥȤκ */
                .global hospac_swi_ctx         /* ¹ԥƥȤ */

/************************************************
  ߶ػ
  void hospac_dis_int(void)
************************************************/
/* ơ쥸IEӥåȤ0ˤ */
                .text
                .align  2
hospac_dis_int:
                mfc0    t0, CP0_STATUS          /* CP0쥸 */
                la      t1, 0xfffffffe          /* IE=0 */
                and     t0, t0, t1
                mtc0    t0, CP0_STATUS          /* CP0쥸򥹥ȥ */
                jr      ra
                nop

/************************************************
  ߵ
  void hospac_ena_int(void)
************************************************/
/* ơ쥸IEӥåȤ1ˤ */
                .text
                .align  2
hospac_ena_int:
                mfc0    t0, CP0_STATUS          /* CP0쥸 */
                la      t1, 0x00000001          /* IE=1 */
                or      t0, t0, t1
                mtc0    t0, CP0_STATUS          /* CP0쥸򥹥ȥ */
                jr      ra
                nop

/************************************************
  ¹ԥƥȥȥ꡼ɥ쥹
************************************************/
                .text
                .align 2
ctx_entry:      
                j       a1                      /* ¹ԥɥ쥹a1˥סa0¹Իѥ᡼ */
                nop

/************************************************
  ¹ԥƥȤκ
  void hospac_cre_ctx_asm(
         T_HOSPAC_CTXINF *pk_ctxinf,    륳ƥ
         VP     sp,                     åݥ
         void   (*task)(VP_INT),        ¹ԥɥ쥹
         VP_INT exinf)                  ¹Իѥ᡼
************************************************/
                .text
                .align 2
hospac_cre_ctx_asm:
                move    k0, a1                  /* åݥ󥿤 */
                subu    a1, a1, SF_SIZE         /* åοĥ4*72=288Хȡ*/
//                sw      a2, 4*5(a1)             /* ¹ԥɥ쥹γǼ */
                sw      a3, 4*4(a1)             /* ¹ԥѥ᡼γǼ */
                sw      k0, 4*29(a1)            /* åݥ󥿤 */
#if 0        
                la      k0, ctx_entry           /* ¹ԥȥݥȤ꥿󥢥ɥ쥹 */
                sw      k0, 4*31(a1)
#else
                sw      a2, 4*31(a1)
#endif
                mfc0    k0, CP0_STATUS          /* CP0_STATUS */
                sw      k0, 4*36(a1)
                
                sw      a1, (a0)                /* ƥȤΥåݥ¸ */
                jr      ra                      /* ƤӽФص */
                nop

/************************************************
  ¹ԥƥȤ
  void hospac_swi_ctx(
        T_HOSPAC_CTXINF *pk_pre_ctxinf, ߤΥƥȤ¸
        T_HOSPAC_CTXINF *pk_nxt_ctxinf) ڤؤ륳ƥ
************************************************/
                .text
                .align 2
hospac_swi_ctx:
                move    k0, sp                  /* ĥΥåݥ󥿤 */
                subu    sp, sp, SF_SIZE         /* åĥ */
#if 0
                sw      $0, 4*0(sp)             /* zero ɬפʤ*/
                .set noat
                sw      $1, 4*1(sp)             /* at    */
#endif        
                sw      $2, 4*2(sp)             /* v0    */
                sw      $3, 4*3(sp)             /* v1    */
                sw      $4, 4*4(sp)             /* a0    */
                sw      $5, 4*5(sp)             /* a1    */
                sw      $6, 4*6(sp)             /* a2    */
                sw      $7, 4*7(sp)             /* a3    */
                sw      $8, 4*8(sp)             /* t0    */
                sw      $9, 4*9(sp)             /* t1    */
                sw      $10, 4*10(sp)           /* t2    */
                sw      $11, 4*11(sp)           /* t3    */
                sw      $12, 4*12(sp)           /* t4    */
                sw      $13, 4*13(sp)           /* t5    */
                sw      $14, 4*14(sp)           /* t6    */
                sw      $15, 4*15(sp)           /* t7    */
                sw      $16, 4*16(sp)           /* s0    */
                sw      $17, 4*17(sp)           /* s1    */
                sw      $18, 4*18(sp)           /* s2    */
                sw      $19, 4*19(sp)           /* s3    */
                sw      $20, 4*20(sp)           /* s4    */
                sw      $21, 4*21(sp)           /* s5    */
                sw      $22, 4*22(sp)           /* s6    */
                sw      $23, 4*23(sp)           /* s7    */
                sw      $24, 4*24(sp)           /* t8    */
                sw      $25, 4*25(sp)           /* t9    */
                sw      $26, 4*26(sp)           /* k0   ɬפʤ*/
                sw      $27, 4*27(sp)           /* k1   ɬפʤ*/
#if 0
                sw      $28, 4*28(sp)           /* gp   ɬפʤ*/
#endif
                sw      k0,  4*29(sp)           /* sp   ʿĥ͡*/
#if 1
                sw      $30, 4*30(sp)           /* fp   ɬפʤ*/
#endif
                sw      $31, 4*31(sp)           /* ra    */

                sw      sp, (a0)                /* spΰ */
                lw      sp, (a1)                /* ΰ褫sp */
                lw      $2, 4*2(sp)             /* v0    */
                lw      $3, 4*3(sp)             /* v1    */
                lw      $4, 4*4(sp)             /* a0    */
                lw      $5, 4*5(sp)             /* a1    */
                lw      $6, 4*6(sp)             /* a2    */
                lw      $7, 4*7(sp)             /* a3    */
                lw      $8, 4*8(sp)             /* t0    */
                lw      $9, 4*9(sp)             /* t1    */
                lw      $10, 4*10(sp)           /* t2    */
                lw      $11, 4*11(sp)           /* t3    */
                lw      $12, 4*12(sp)           /* t4    */
                lw      $13, 4*13(sp)           /* t5    */
                lw      $14, 4*14(sp)           /* t6    */
                lw      $15, 4*15(sp)           /* t7    */
                lw      $16, 4*16(sp)           /* s0    */
                lw      $17, 4*17(sp)           /* s1    */
                lw      $18, 4*18(sp)           /* s2    */
                lw      $19, 4*19(sp)           /* s3    */
                lw      $20, 4*20(sp)           /* s4    */
                lw      $21, 4*21(sp)           /* s5    */
                lw      $22, 4*22(sp)           /* s6    */
                lw      $23, 4*23(sp)           /* s7    */
                lw      $24, 4*24(sp)           /* t8    */
                lw      $25, 4*25(sp)           /* t9    */
                lw      $26, 4*26(sp)           /* k0   ɬפʤ*/
                lw      $27, 4*27(sp)           /* k1   ɬפʤ*/
#if 0
                lw      $28, 4*28(sp)           /* gp   ɬפʤ*/
#endif
                lw      $30, 4*30(sp)           /* fp   ɬפʤ*/
                lw      $31, 4*31(sp)           /* ra    */

                lw      $29, 4*29(sp)           /* sp    */
                jr      ra                      /* ƥȤإ */
                nop

/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
