/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ̥ͥ ƥ ƥॿ¹                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"


static void mknl_exe_sys_start(VP_INT exinf);	/* ƥॿμ¹ */

static FP mknl_exe_sys_exec;					/* ƥ¹ */


/* ƥ¹  */
void mknl_exe_sys(
		FP     exec,
		VP_INT exinf)
{
	T_HOSPAC_CTXINF *ctxinf_run;
	
	/* ¹楳ƥȤ */
	ctxinf_run = &mknl_run_mtcb->ctxinf;
	
	/* ƥ¹¸ */
	mknl_exe_sys_exec = exec;
	
	/* ɥ륳ƥȤ򥷥ƥॿȤư */
	hospac_del_ctx(&mknl_idlctx);												/* ɥ륳ƥȤ˴ */
	hospac_cre_ctx(&mknl_idlctx, exinf, exec, mknl_idl_stksz, mknl_idl_stk);	/* ɥ륿 */
	
	/* ƥȥå¹ */
	mknl_run_mtcb = NULL;
	hospac_swi_ctx(ctxinf_run, &mknl_idlctx);
}


/* ƥॿμ¹ */
void mknl_exe_sys_start(VP_INT exinf)
{
	/* ƥॿǼ¹ */
	mknl_exe_sys_exec(exinf);
	
	/* λ奢ɥ */
	mknl_idl_loop();
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
