/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ̥ͥ                                                  */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"
#include "dsp_hok.h"



/* ǥѥåμ¹ */
ER_UINT mknl_exe_dsp(void)
{
	T_HOSPAC_CTXINF *ctxinf_top;
	T_HOSPAC_CTXINF *ctxinf_run;
	T_MKNL_TCB *mtcb_top;
	T_MKNL_TCB *mtcb_run;

	/* ƥȥå */
	if ( mknl_ctx_stat & (MKNL_TSS_INDP | MKNL_TSS_DDSP | MKNL_TSS_DINT) )
	{
		/* ǥѥå¹Բǽ̵֤α */
		mknl_ctx_stat |= MKNL_TSS_DDLY;	/* ǥѥåٱե饰򥻥å */
		return E_OK;
	}

	/* ǹͥ٤μ¹Բǽõ */
	mtcb_top = mknl_srh_top();

	mtcb_run = mknl_run_mtcb;	/* ߤΥ */

	/* ¹楿Ʊʤ鲿⤷ʤ(ɥ뤫饢ɥޤ */
	if ( mtcb_top == mtcb_run )
	{
		if ( mtcb_run == NULL )
		{
			return E_OK;
		}
		return mtcb_run->ercd;
	}

	/* ɥ륿¹Ǥʤå */
	if ( mtcb_run == NULL )
	{
		/* ɥʤ饢ɥ륳ƥȤ */
		ctxinf_run = &mknl_idlctx;
	}
	else
	{
		/* ¹ΥƥȤ */
		ctxinf_run = &mtcb_run->ctxinf;
	}

	/* ˼¹Ԥ륿뤫ɤå */
	if ( mtcb_top == NULL )
	{
		/* ¹褬̵Хɥ륳ƥȤ */
		mknl_run_mtcb = NULL;
		ctxinf_top    = &mknl_idlctx;
	}
	else
	{
		/* ¹Υ¹楿ȤϿ */
		mknl_run_mtcb     = mtcb_top;
		mtcb_top->tskstat = TTS_RDY;
		
		/* ¹ΥƥȤ */
		ctxinf_top = &mtcb_top->ctxinf;
	}

	/* ƥȥå¹ */
	hospac_swi_ctx(ctxinf_run, ctxinf_top);

	_HOS_TSW_HOK();		/* ƥȥåΥեå */

	if ( mtcb_run == NULL )
	{
		return E_OK;
	}

	return mtcb_run->ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
