<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query">
	<script type="text/javascript" src="../customan/ankKomoku.js" ><!-- --></script>
	<script type="text/javascript" src="antitimeout.js" ><!-- --></script>
	<style type="text/css">
		input#backButton { margin:10px; }
		div.orgRowCntMsg { margin:0px 12px; }
	</style>
</og:head>
<jsp:directive.include file="/jsp/custom/query_info.jsp" />

<!-- キーのチェック・復号化 -->
<og:bizLogic logics="an.OP0001S" keys="KEY" />
<og:value command="SET" key="CDANK" value="{@RETURN}" />

<og:value command="SQL">
	select A.USERID,A.FGKOKAI,A.DYKSTR,A.DYKEND,A.FGNODPL,A.FGSHUBETSU,case when A.FGRESDISP in ('1','2') then 'true' else '' end RESDISP
	from AN01 A
	where A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
</og:value>

<og:equals val1="{@FGKOKAI}" val2="4">
	<og:equals val1="{@USER.ID}" val2="GUEST">
		<jsp:scriptlet>
			String url = ((HttpServletRequest)request).getRequestURL().toString() + "?" + ((HttpServletRequest)request).getQueryString();
			request.setAttribute( "BACK_URL", url );
		</jsp:scriptlet>
		<og:forward page="../login.jsp" keys="BACK_URL" vals="{@BACK_URL}" useRedirect="true" />
	</og:equals>
</og:equals>


<og:equals val1="34" val2="{@FGKOKAI}" contains="true">
	<!-- 回答者IDのチェック -->
	<og:bizLogic logics="an.OP0002S" keys="CDANK,FGKOKAI,UID" />
	<og:value command="SET" key="KUID" value="{@RETURN}" />
</og:equals>

<!-- ANE0001:このアンケートは公開されていません。-->
<og:dataCheck command="NEW" msg="ANE0001" beforeErrorJsp="/jsp/common/history_back.jsp">
	'{@FGKOKAI}' != '0'
</og:dataCheck>

<!-- ANE0003:このアンケートはまだ開始していません。-->
<og:dataCheck command="NEW" msg="ANE0003" beforeErrorJsp="/jsp/common/history_back.jsp">
	'{@USER.YMD}' &gt;= '{@DYKSTR}'
</og:dataCheck>

<og:value command="SQL">
	select NOKAITO, SUSPOINT, DYKAITO
	from AN11 A
	where A.USERID = '{@USERID}'
	and A.CDANK = '{@CDANK}'
	and A.FGJ = '1'
	<og:equals val1="{@FGKOKAI}" val2="3">
	and A.KUID = '{@KUID}'
	</og:equals>
	<og:equals val1="{@FGKOKAI}" val2="4">
	and A.KUID = '{@USER.ID}'
	</og:equals>
	<og:equals val1="34" val2="{@FGKOKAI}" contains="true" notEquals="true">
		<og:equals val1="{@USER.ID}" val2="GUEST">
			and A.KIPADDR = '{@USER.IPADDRESS}'
		</og:equals>
		<og:equals val1="{@USER.ID}" val2="GUEST" notEquals="true">
			and A.KUID = '{@USER.ID}'
		</og:equals>
	</og:equals>
	order by A.NOKAITO desc
</og:value>

<!-- ANE0004:このアンケートは既に終了しています。-->
<og:dataCheck command="NEW" msg="ANE0004"
	beforeErrorJsp="/jsp/common/history_back.jsp"
	afterErrorJsp="thanks.jsp">
	'{@USER.YMD}' &lt;= '{@DYKEND}'
</og:dataCheck>

<og:equals val1="{@FGNODPL}" val2="1">
	<!-- ANE0006:このアンケートには既に回答済みです。-->
	<og:dataCheck command="NEW" msg="ANE0006"
		beforeErrorJsp="/jsp/common/history_back.jsp"
		afterErrorJsp="thanks.jsp">
		'{@NOKAITO}' == ''
	</og:dataCheck>
</og:equals>

<og:equals val1="{@RESDISP}" nullCheck="true" notEquals="true">
<og:equals val1="{@NOKAITO}" nullCheck="true" notEquals="true">
	<div style="padding:10px;">
		<og:equals val1="{@NOKAITO}" nullCheck="true" notEquals="true">
			<!-- ANM0036:あなたはこのアンケートに回答済みです。 -->
			<span style="color:red; "><b><og:text>{@LBL.ANM0036}</og:text></b></span>
			<og:equals val1="{@FGSHUBETSU}" val2="2">
				<!-- ANM0037:得点( {0} 点 ) -->
				&amp;nbsp;<span style="color:red; "><b><og:text>{@LBL.ANM0037 @SUSPOINT}</og:text></b></span>
			</og:equals>
			<br /><br />
		</og:equals>
		<!-- ANM0009:【アンケートの集計結果を見る】-->
		<og:link href="index.jsp" gamenId="OP1101" lbl="ANM0009" keys="KEY,UVIEW" vals="{@KEY},true" />
	</div>
</og:equals>
</og:equals>

<!--
	 ANE0034:回答後、10分以内は回答を行うことができません。
<og:equals val1="{@DYKAITO}" nullCheck="true" notEquals="true">
	<og:dataCheck command="NEW" msg="ANE0034"
		beforeErrorJsp="/jsp/common/history_back.jsp">
			new Date().getTime()
			- ( new Date(
				'{@DYKAITO}'.substring( 0,4 )
				, '{@DYKAITO}'.substring( 4,6 ) - 1
				, '{@DYKAITO}'.substring( 6,8 )
				, '{@DYKAITO}'.substring( 8,10 )
				, '{@DYKAITO}'.substring( 10,12 )
				, '{@DYKAITO}'.substring( 12,14 )
			) ).getTime()
			&gt; 10 * 60 * 1000
	</og:dataCheck>
</og:equals>
-->

<form method="POST" action="forward.jsp">
<div class="contents">
<jsp:directive.include file="/jsp/customan/ankVIEW.jsp" />
</div>

<div style="text-align:center;margin-bottom:20px;">
	<og:submit value="confirm" lbl="CONFIRM" accesskey="C"  />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
	<og:hidden name="KEY" value="{@KEY}" />
	<og:hidden name="KUID" value="{@KUID}" />

	<og:bizLogic logics="an.OP1003S" />
	<og:value command="SET" key="T_NOKAITO" value="{@RETURN}" />
	<og:hidden name="T_NOKAITO" value="{@T_NOKAITO}" />
</div>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
