/*
 * Decompiled with CFR 0.152.
 */
package iax.audio.impl;

import iax.audio.Player;
import iax.audio.PlayerException;
import java.io.ByteArrayInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class ULAWPlayer
extends Player {
    SourceDataLine sourceDataLine;
    AudioFormat pcmFormat;
    AudioFormat ulawFormat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, false);

    public ULAWPlayer() throws PlayerException {
        super(1);
        this.pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false);
        this.openSourceDataLine();
    }

    private void openSourceDataLine() {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.pcmFormat);
        try {
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceDataLine.open(this.pcmFormat);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void play() {
        this.sourceDataLine.start();
    }

    public void stop() {
        this.sourceDataLine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long timestamp, byte[] audioData, boolean absolute) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(audioData);
            AudioInputStream ais = new AudioInputStream(byteArrayInputStream, this.ulawFormat, -1L);
            AudioInputStream realNetStream = AudioSystem.getAudioInputStream(this.pcmFormat, ais);
            SourceDataLine sourceDataLine = this.sourceDataLine;
            synchronized (sourceDataLine) {
                int cnt;
                int len = 160;
                byte[] tempBuffer = new byte[len];
                while ((cnt = realNetStream.read(tempBuffer, 0, tempBuffer.length)) != -1) {
                    if (cnt > 0) {
                        this.sourceDataLine.write(tempBuffer, 0, cnt);
                        continue;
                    }
                    if (cnt != 0) break;
                    Thread.sleep(15L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

