/*
 * Decompiled with CFR 0.152.
 */
package iax.audio.impl;

import iax.audio.AudioListener;
import iax.audio.Recorder;
import iax.audio.RecorderException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class ULAWRecorder
extends Recorder {
    AudioListener al;
    boolean recording = true;
    int buffer_size;
    Thread captureThread;
    AudioFormat ulawFormat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, false);
    AudioFormat pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false);
    TargetDataLine targetDataLine;
    AudioInputStream linearStream;

    public ULAWRecorder() throws RecorderException {
        this.openTargetDataLine();
    }

    private void openTargetDataLine() {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.pcmFormat);
        try {
            this.targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            this.targetDataLine.open(this.pcmFormat);
            this.targetDataLine.start();
            AudioInputStream ais = new AudioInputStream(this.targetDataLine);
            this.linearStream = AudioSystem.getAudioInputStream(this.ulawFormat, ais);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.recording = false;
    }

    public void record(AudioListener al) {
        this.al = al;
        this.buffer_size = 160;
        this.buffer_size -= this.buffer_size % 2;
        this.recording = true;
        this.captureThread = new Thread(new CaptureThread());
        this.captureThread.start();
    }

    class CaptureThread
    extends Thread {
        CaptureThread() {
        }

        public void run() {
            byte[] buffer = new byte[ULAWRecorder.this.buffer_size];
            try {
                while (ULAWRecorder.this.recording) {
                    int count = ULAWRecorder.this.linearStream.read(buffer, 0, buffer.length);
                    if (count > 0) {
                        ULAWRecorder.this.al.listen(buffer, 0, count);
                        continue;
                    }
                    if (count != 0) continue;
                    Thread.sleep(15L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

