/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gdata.model.Attribute;
import com.google.gdata.model.AttributeIterator;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.ElementIterator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementVisitor;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Category;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.base.Objects;
import com.google.gdata.util.common.base.Pair;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.wireformats.ContentCreationException;
import com.google.gdata.wireformats.ContentValidationException;
import com.google.gdata.wireformats.ObjectConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element {
    private static final Logger LOGGER = Logger.getLogger(Element.class.getName());
    private final ElementKey<?, ?> key;
    private final ElementState state;

    public static ElementKey<?, ?> getDefaultKey(Class<? extends Element> type) {
        Preconditions.checkNotNull(type, "type");
        ElementKey key = null;
        try {
            Field keyField = type.getField("KEY");
            key = (ElementKey)ElementKey.class.cast(keyField.get(null));
        }
        catch (NoSuchFieldException nsfe) {
            throw new IllegalArgumentException("Unable to access KEY field:" + type, nsfe);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Unable to access KEY field:" + type, iae);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Unable to access KEY field:" + type, iae);
        }
        catch (NullPointerException npe) {
            throw new IllegalArgumentException("Unable to access KEY field:" + type, npe);
        }
        return key;
    }

    public Element(ElementKey<?, ?> elementKey) {
        Preconditions.checkNotNull(elementKey, "elementKey");
        this.key = Element.bindKey(elementKey, this.getClass());
        this.state = new ElementState();
    }

    public Element(QName qName) {
        this.key = ElementKey.of(qName, String.class, this.getClass());
        this.state = new ElementState();
    }

    public Element(ElementKey<?, ?> elementKey, Element source) {
        this.key = Element.bindKey(elementKey, this.getClass());
        this.state = source.state;
    }

    private static ElementKey<?, ?> bindKey(ElementKey<?, ?> key, Class<? extends Element> type) {
        Class<?> keyType = key.getElementType();
        if (keyType == type) {
            return key;
        }
        return ElementKey.of(key.getId(), key.getDatatype(), type);
    }

    public final boolean isLocked() {
        return this.state.locked;
    }

    public Element lock() {
        this.state.locked = true;
        if (this.state.attributes != null) {
            for (Attribute att : this.state.attributes.values()) {
                att.lock();
            }
        }
        if (this.state.elements != null) {
            for (Object childObj : this.state.elements.values()) {
                if (childObj instanceof Element) {
                    ((Element)childObj).lock();
                    continue;
                }
                for (Element child : this.castElementCollection(childObj)) {
                    child.lock();
                }
            }
        }
        return this;
    }

    private void throwExceptionIfLocked() {
        Preconditions.checkState(!this.state.locked, "%s instance is read only", this.getElementId());
    }

    public ElementKey<?, ?> getElementKey() {
        return this.key;
    }

    public QName getElementId() {
        return this.key.getId();
    }

    public Iterator<Attribute> getAttributeIterator() {
        return this.getAttributeIterator(null);
    }

    public Iterator<Attribute> getAttributeIterator(ElementMetadata<?, ?> metadata) {
        return new AttributeIterator(this, metadata, this.state.attributes);
    }

    public int getAttributeCount() {
        return this.state.attributes != null ? this.state.attributes.size() : 0;
    }

    public boolean hasAttribute(QName id) {
        return this.state.attributes == null ? false : this.state.attributes.containsKey(id);
    }

    public boolean hasAttribute(AttributeKey<?> childKey) {
        return this.hasAttribute(childKey.getId());
    }

    public Object getAttributeValue(QName id) {
        if (this.state.attributes == null) {
            return null;
        }
        Attribute attribute = (Attribute)this.state.attributes.get(id);
        return attribute == null ? null : attribute.getValue();
    }

    public <T> T getAttributeValue(AttributeKey<T> key) {
        Object value;
        Attribute attribute = this.state.attributes == null ? null : (Attribute)this.state.attributes.get(key.getId());
        Object object = value = attribute == null ? null : attribute.getValue();
        if (value == null) {
            return null;
        }
        try {
            return (T)ObjectConverter.getValue(value, key.getDatatype());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Unable to convert value " + e + " to datatype " + key.getDatatype());
        }
    }

    public Element setAttributeValue(QName id, Object attrValue) {
        return this.setAttributeValue(AttributeKey.of(id), attrValue);
    }

    public Element setAttributeValue(AttributeKey<?> key, Object attrValue) {
        if (attrValue == null) {
            this.removeAttributeValue(key);
        } else {
            this.setAttribute(key, new Attribute(key, attrValue));
        }
        return this;
    }

    private void setAttribute(AttributeKey<?> attKey, Attribute attribute) {
        this.throwExceptionIfLocked();
        if (this.state.attributes == null) {
            this.state.attributes = new LinkedHashMap();
        }
        this.state.attributes.put(attKey.getId(), attribute);
    }

    @Deprecated
    public Object removeAttribute(QName id) {
        return this.removeAttributeValue(id);
    }

    public Object removeAttributeValue(QName id) {
        this.throwExceptionIfLocked();
        Attribute removed = this.state.attributes == null ? null : (Attribute)this.state.attributes.remove(id);
        return removed == null ? null : removed.getValue();
    }

    @Deprecated
    public Object removeAttribute(AttributeKey<?> key) {
        return this.removeAttributeValue(key);
    }

    public Object removeAttributeValue(AttributeKey<?> key) {
        return this.removeAttributeValue(key.getId());
    }

    public Iterator<Element> getElementIterator() {
        return this.getElementIterator(null);
    }

    public Iterator<Element> getElementIterator(ElementMetadata<?, ?> metadata) {
        return new ElementIterator(this, metadata, this.state.elements);
    }

    public int getElementCount() {
        int elementCount = 0;
        if (this.state.elements != null) {
            for (Object elementValue : this.state.elements.values()) {
                if (elementValue instanceof Collection) {
                    elementCount += this.castElementCollection(elementValue).size();
                    continue;
                }
                ++elementCount;
            }
        }
        return elementCount;
    }

    public Element getElement(QName id) {
        Object mapValue = this.getElementObject(id);
        if (mapValue instanceof Element) {
            return (Element)mapValue;
        }
        Preconditions.checkArgument(!(mapValue instanceof Collection), "The getElement(*) method was called for a repeating element.  Use getElements(*) instead.");
        return null;
    }

    public <D, T extends Element> T getElement(ElementKey<D, T> childKey) {
        Element child = this.getElement(childKey.getId());
        if (child == null) {
            return null;
        }
        try {
            return this.adapt(childKey, child);
        }
        catch (ContentCreationException e) {
            throw new IllegalArgumentException("Unable to adapt to " + childKey.getElementType(), e);
        }
    }

    private Object getElementObject(QName id) {
        XmlNamespace ns;
        if (this.state.elements == null) {
            return null;
        }
        if ("*".equals(id.getLocalName()) && (ns = id.getNs()) != null) {
            String uri = ns.getUri();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry entry : this.state.elements.entrySet()) {
                QName key = (QName)entry.getKey();
                XmlNamespace keyNs = key.getNs();
                if (keyNs == null || !uri.equals(keyNs.getUri())) continue;
                Object value = entry.getValue();
                if (value instanceof Element) {
                    builder.add((Element)value);
                    continue;
                }
                builder.addAll((Iterable)this.castElementCollection(value));
            }
            return builder.build();
        }
        return this.state.elements.get(id);
    }

    private Object getElementObject(ElementKey<?, ?> childKey) {
        return this.getElementObject(childKey.getId());
    }

    public Object getElementValue(QName id) {
        Element e = this.getElement(id);
        return e == null ? null : e.getTextValue();
    }

    public <V> V getElementValue(ElementKey<V, ? extends Element> key) {
        Element e = this.getElement(key);
        return e == null ? null : (V)e.getTextValue(key);
    }

    public boolean hasElement(QName id) {
        return this.state.elements == null ? false : this.state.elements.containsKey(id);
    }

    public boolean hasElement(ElementKey<?, ?> childKey) {
        return this.hasElement(childKey.getId());
    }

    public List<Element> getElements(QName id) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Object obj = this.getElementObject(id);
        if (obj != null) {
            if (obj instanceof Element) {
                builder.add((Element)obj);
            } else {
                for (Element e : this.castElementCollection(obj)) {
                    builder.add(e);
                }
            }
        }
        return builder.build();
    }

    public <T extends Element> List<T> getElements(ElementKey<?, T> key) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Object obj = this.getElementObject(key);
        if (obj != null) {
            Class<T> childType = key.getElementType();
            if (obj instanceof Element) {
                if (childType.isInstance(obj)) {
                    builder.add(childType.cast(obj));
                }
            } else {
                for (Element e : this.castElementCollection(obj)) {
                    if (!childType.isInstance(e)) continue;
                    builder.add(childType.cast(e));
                }
            }
        }
        return builder.build();
    }

    public Set<Element> getElementSet(QName id) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Object obj = this.getElementObject(id);
        if (obj != null) {
            if (obj instanceof Element) {
                builder.add((Element)obj);
            } else {
                for (Element e : this.castElementCollection(obj)) {
                    builder.add(e);
                }
            }
        }
        return builder.build();
    }

    public <T extends Element> Set<T> getElementSet(ElementKey<?, T> key) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Object obj = this.getElementObject(key);
        if (obj != null) {
            Class<T> childType = key.getElementType();
            if (obj instanceof Element) {
                if (childType.isInstance(obj)) {
                    builder.add(childType.cast(obj));
                }
            } else {
                for (Element e : this.castElementCollection(obj)) {
                    if (!childType.isInstance(e)) continue;
                    builder.add(childType.cast(e));
                }
            }
        }
        return builder.build();
    }

    public Element setElement(QName id, Element element) {
        this.removeElement(id);
        if (element != null) {
            this.addElement(id, element);
        }
        return this;
    }

    public Element setElement(Element element) {
        Preconditions.checkNotNull(element);
        this.setElement(element.getElementKey(), element);
        return this;
    }

    public Element setElement(ElementKey<?, ?> key, Element element) {
        this.removeElement(key);
        if (element != null) {
            this.addElement(key, element);
        }
        return this;
    }

    public Element addElement(Element element) {
        Preconditions.checkNotNull(element);
        this.addElement(element.getElementKey(), element);
        return this;
    }

    public Element addElement(QName id, Element element) {
        Preconditions.checkNotNull(element);
        this.addElement(ElementKey.of(id, element.getElementKey().getDatatype(), element.getClass()), element);
        return this;
    }

    public Element addElement(ElementKey<?, ?> key, Element element) {
        ElementKey<?, ?> elementKey;
        this.throwExceptionIfLocked();
        if (this.state.elements == null) {
            this.state.elements = new LinkedHashMap();
        }
        if (!(key = this.calculateKey(key, elementKey = element.getElementKey())).equals(elementKey)) {
            try {
                element = Element.createElement(key, element);
            }
            catch (ContentCreationException e) {
                throw new IllegalArgumentException("Key " + key + " cannot be applied" + " to element with key " + elementKey);
            }
        }
        QName id = key.getId();
        Object obj = this.state.elements.get(id);
        if (obj == null) {
            this.state.elements.put(id, element);
        } else if (obj instanceof Collection) {
            Collection collect = this.castElementCollection(obj);
            collect.add(element);
        } else {
            Collection collect = this.createCollection(key);
            collect.add((Element)obj);
            collect.add(element);
            this.state.elements.put(id, collect);
        }
        return this;
    }

    private ElementKey<?, ?> calculateKey(ElementKey<?, ?> key, ElementKey<?, ?> sourceKey) {
        Class<?> sourceType;
        Class<?> keyType = key.getElementType();
        if (keyType != (sourceType = sourceKey.getElementType()) && keyType.isAssignableFrom(sourceType)) {
            key = ElementKey.of(key.getId(), key.getDatatype(), sourceType);
        }
        return key;
    }

    public Element removeElement(QName id) {
        this.throwExceptionIfLocked();
        if (this.state.elements != null) {
            this.state.elements.remove(id);
        }
        return this;
    }

    public Element removeElement(ElementKey<?, ?> childKey) {
        return this.removeElement(childKey.getId());
    }

    public boolean removeElement(Element element) {
        return this.removeElement(element.getElementKey(), element);
    }

    public boolean removeElement(ElementKey<?, ?> childKey, Element element) {
        this.throwExceptionIfLocked();
        boolean removed = false;
        if (this.state.elements != null) {
            Object obj = this.getElementObject(childKey);
            if (obj instanceof Collection) {
                Collection collect = this.castElementCollection(obj);
                Iterator iter = collect.iterator();
                while (iter.hasNext()) {
                    if (iter.next() != element) continue;
                    iter.remove();
                    removed = true;
                    break;
                }
                if (collect.isEmpty()) {
                    this.removeElement(childKey);
                }
            } else if (obj == element) {
                this.removeElement(childKey);
                removed = true;
            }
        }
        return removed;
    }

    public boolean replaceElement(Element toRemove, Element toAdd) {
        this.throwExceptionIfLocked();
        if (toAdd == null) {
            return this.removeElement(toRemove);
        }
        QName id = toRemove.getElementId();
        if (!id.equals(toAdd.getElementId())) {
            boolean removed = this.removeElement(toRemove);
            if (removed) {
                this.addElement(toAdd);
            }
            return removed;
        }
        if (this.state.elements != null) {
            Object obj = this.state.elements.get(id);
            if (obj instanceof List) {
                List list = this.castElementList(obj);
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) != toRemove) continue;
                    list.set(i, toAdd);
                    return true;
                }
            } else if (obj instanceof Set) {
                Set set = this.castElementSet(obj);
                if (set.remove(toRemove)) {
                    set.add(toAdd);
                }
            } else if (obj == toRemove) {
                this.state.elements.put(id, toAdd);
                return true;
            }
        }
        return false;
    }

    private <T extends Element> List<T> castElementList(Object obj) {
        return (List)obj;
    }

    private <T extends Element> Set<T> castElementSet(Object obj) {
        return (Set)obj;
    }

    private <T extends Element> Collection<T> castElementCollection(Object obj) {
        return (Collection)obj;
    }

    private <T extends Element> Collection<T> createCollection(ElementKey<?, ?> key) {
        Class<?> elementType = key.getElementType();
        if (Category.class.isAssignableFrom(elementType)) {
            return Sets.newLinkedHashSet();
        }
        return Lists.newArrayList();
    }

    public void clear() {
        this.throwExceptionIfLocked();
        this.state.value = null;
        this.state.attributes = null;
        this.state.elements = null;
    }

    public Object getTextValue() {
        return this.state.value;
    }

    public <V> V getTextValue(ElementKey<V, ?> key) {
        if (this.state.value != null) {
            try {
                return (V)ObjectConverter.getValue(this.state.value, key.getDatatype());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Unable to convert value " + e + " to datatype " + key.getDatatype());
            }
        }
        return null;
    }

    public Element setTextValue(Object newValue) {
        this.throwExceptionIfLocked();
        this.state.value = this.checkValue(this.key, newValue);
        return this;
    }

    Object checkValue(ElementKey<?, ?> elementKey, Object newValue) {
        if (newValue != null) {
            Class datatype = elementKey.getDatatype();
            Preconditions.checkArgument(datatype != Void.class, "Element must not contain a text node");
            Preconditions.checkArgument(datatype.isInstance(newValue), "Invalid class: %s", newValue.getClass().getCanonicalName());
        }
        return newValue;
    }

    public boolean hasTextValue() {
        return this.state.value != null;
    }

    public Element resolve(ElementMetadata<?, ?> metadata) throws ContentValidationException {
        ValidationContext vc = new ValidationContext();
        Element narrowed = this.resolve(metadata, vc);
        if (!vc.isValid()) {
            throw new ContentValidationException("Invalid data", vc);
        }
        return narrowed;
    }

    public Element resolve(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        if (metadata == null) {
            return this;
        }
        Element narrowed = this.narrow(metadata, vc);
        narrowed.validate(metadata, vc);
        Iterator<Element> childIterator = narrowed.getElementIterator();
        if (childIterator.hasNext()) {
            ArrayList<Pair<Element, Element>> replacements = Lists.newArrayList();
            while (childIterator.hasNext()) {
                ElementMetadata<?, ?> elementMetadata;
                Element child = childIterator.next();
                Element resolved = child.resolve(elementMetadata = metadata.bindElement(child.getElementKey()), vc);
                if (resolved == child) continue;
                replacements.add(Pair.of(child, resolved));
            }
            for (Pair pair : replacements) {
                narrowed.replaceElement((Element)pair.getFirst(), (Element)pair.getSecond());
            }
        }
        return narrowed;
    }

    protected Element narrow(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        ElementKey<?, ?> narrowedKey = metadata.getKey();
        Class<?> narrowedType = narrowedKey.getElementType();
        if (!narrowedType.isInstance(this)) {
            if (!this.getClass().isAssignableFrom(narrowedType)) {
                LOGGER.severe("Element of type " + this.getClass() + " cannot be narrowed to type " + narrowedType);
            }
            try {
                return this.adapt(narrowedKey, this);
            }
            catch (ContentCreationException e) {
                LOGGER.log(Level.SEVERE, "Unable to adapt " + this.getClass() + " to " + narrowedType, e);
            }
        }
        return this;
    }

    protected Element adapt(Element source, ElementMetadata<?, ?> sourceMeta, String kind) {
        ElementKey<?, ?> adaptorKey = sourceMeta.adapt(kind);
        if (adaptorKey != null) {
            try {
                return this.adapt(adaptorKey, source);
            }
            catch (ContentCreationException e) {
                LOGGER.log(Level.SEVERE, "Unable to adapt " + source.getClass() + " to " + adaptorKey.getElementType(), e);
            }
        }
        return source;
    }

    protected <T extends Element> T adapt(ElementKey<?, T> key, Element source) throws ContentCreationException {
        Preconditions.checkNotNull(key);
        Class<T> adaptingTo = key.getElementType();
        if (source == null || adaptingTo.isInstance(source)) {
            return (T)((Element)adaptingTo.cast(source));
        }
        Class<T> adaptingFrom = source.getClass();
        Preconditions.checkArgument(adaptingFrom.isAssignableFrom(adaptingTo), "Cannot adapt from element of type %s to an element of type %s", adaptingFrom, adaptingTo);
        return Element.createElement(key, source);
    }

    protected void validate(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        if (metadata != null) {
            metadata.validate(vc, this);
        }
    }

    public void visit(ElementVisitor ev, ElementMetadata<?, ?> meta) {
        this.visit(ev, null, meta);
    }

    private void visit(ElementVisitor ev, Element parent, ElementMetadata<?, ?> meta) throws ElementVisitor.StoppedException {
        boolean visitChildren = ev.visit(parent, this, meta);
        if (visitChildren) {
            this.visitChildren(ev, meta);
        }
        ev.visitComplete(parent, this, meta);
    }

    private void visitChildren(ElementVisitor ev, ElementMetadata<?, ?> meta) throws ElementVisitor.StoppedException {
        Iterator<Element> childIterator = this.getElementIterator(meta);
        while (childIterator.hasNext()) {
            Element child = childIterator.next();
            ElementMetadata<?, ?> childMeta = meta == null ? null : meta.bindElement(child.getElementKey());
            child.visit(ev, this, childMeta);
        }
    }

    protected boolean sameClassAs(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }

    protected static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static <E extends Element> E createElement(ElementKey<?, E> key) throws ContentCreationException {
        return Element.createElement(key, null);
    }

    public static <E extends Element> E createElement(ElementKey<?, E> key, Element source) throws ContentCreationException {
        if (source != null && key.equals(source.getElementKey()) && key.getElementType().isInstance(source)) {
            return (E)((Element)key.getElementType().cast(source));
        }
        Class<E> elementClass = key.getElementType();
        try {
            try {
                Object[] args;
                Class[] argTypes;
                if (source != null) {
                    argTypes = new Class[]{ElementKey.class, source.getClass()};
                    args = new Object[]{key, source};
                } else {
                    argTypes = new Class[]{ElementKey.class};
                    args = new Object[]{key};
                }
                return (E)((Element)Element.construct(elementClass, argTypes, args));
            }
            catch (NoSuchMethodException e) {
                try {
                    Object[] args;
                    Class[] argTypes;
                    if (source != null) {
                        argTypes = new Class[]{source.getClass()};
                        args = new Object[]{source};
                    } else {
                        argTypes = new Class[]{};
                        args = new Object[]{};
                    }
                    return (E)((Element)Element.construct(elementClass, argTypes, args));
                }
                catch (NoSuchMethodException e2) {
                    throw new ContentCreationException("Constructor not found: " + elementClass);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new ContentCreationException("Constructor not found: " + elementClass);
        }
        catch (InstantiationException e) {
            throw new ContentCreationException("Constructor not found: " + elementClass);
        }
        catch (InvocationTargetException e) {
            throw new ContentCreationException("Constructor not found: " + elementClass, e.getCause());
        }
    }

    private static <T> T construct(Class<? extends T> clazz, Class<?>[] argTypes, Object[] args) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] ctcs;
        for (Constructor<?> ctc : ctcs = clazz.getDeclaredConstructors()) {
            Class<?>[] paramTypes = ctc.getParameterTypes();
            if (!Element.paramsValid(paramTypes, argTypes)) continue;
            ctc.setAccessible(true);
            return (T)ctc.newInstance(args);
        }
        return clazz.getConstructor(argTypes).newInstance(args);
    }

    private static boolean paramsValid(Class<?>[] paramTypes, Class<?>[] argTypes) {
        if (paramTypes.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].isAssignableFrom(argTypes[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        return this.state.equals(((Element)obj).state);
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this);
        helper.addValue(this.getElementId() + "@" + Integer.toHexString(this.hashCode()));
        Iterator<Attribute> aIter = this.getAttributeIterator();
        while (aIter.hasNext()) {
            Attribute att = aIter.next();
            helper.add(att.getAttributeKey().getId().toString(), att.getValue());
        }
        if (this.hasTextValue()) {
            helper.addValue(this.getTextValue());
        }
        return helper.toString();
    }

    private static class ElementState {
        private Map<QName, Attribute> attributes;
        private Map<QName, Object> elements;
        private Object value;
        private volatile boolean locked;

        private ElementState() {
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper(this);
            if (this.attributes != null) {
                helper.add("attributes", this.attributes.values());
            }
            if (this.elements != null) {
                helper.add("elements", this.elements.values());
            }
            if (this.value != null) {
                helper.add("value", this.value);
            }
            return helper.toString();
        }
    }
}

