/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.IFeed;
import com.google.gdata.data.ILink;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Entry;
import com.google.gdata.model.atom.Kinds;
import com.google.gdata.model.atom.Link;
import com.google.gdata.model.atom.Source;
import com.google.gdata.model.batch.BatchOperation;
import com.google.gdata.model.gd.GdAttributes;
import com.google.gdata.model.gd.Partial;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.NotModifiedException;
import com.google.gdata.util.ServiceException;
import com.google.gdata.wireformats.ContentCreationException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed
extends Source
implements IFeed {
    public static final ElementKey<Void, Feed> KEY = ElementKey.of(new QName(Namespaces.atomNs, "feed"), Feed.class);
    public static final AttributeKey<URI> XML_BASE = AttributeKey.of(new QName(Namespaces.xmlNs, "base"), URI.class);
    public static final ElementKey<Integer, Element> ITEMS_PER_PAGE = ElementKey.of(new QName(Namespaces.openSearch1_1Ns, "itemsPerPage"), Integer.class, Element.class);
    public static final ElementKey<Integer, Element> START_INDEX = ElementKey.of(new QName(Namespaces.openSearch1_1Ns, "startIndex"), Integer.class, Element.class);
    public static final ElementKey<Integer, Element> TOTAL_RESULTS = ElementKey.of(new QName(Namespaces.openSearch1_1Ns, "totalResults"), Integer.class, Element.class);
    protected final FeedState feedState;

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        Source.registerMetadata(registry);
        Partial.registerMetadata(registry);
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(GdAttributes.ETAG);
        builder.addAttribute(GdAttributes.KIND);
        builder.addAttribute(GdAttributes.FIELDS);
        builder.addAttribute(XML_BASE);
        builder.addElement(TOTAL_RESULTS);
        builder.addElement(START_INDEX);
        builder.addElement(ITEMS_PER_PAGE);
        builder.addElement(BatchOperation.KEY);
        builder.addUndeclaredElementMarker();
        builder.addElement(Entry.KEY);
    }

    public Feed() {
        this((ElementKey<?, ? extends Feed>)KEY);
    }

    protected Feed(ElementKey<?, ? extends Feed> key) {
        super((ElementKey<?, ? extends Source>)key);
        this.feedState = new FeedState();
    }

    protected Feed(ElementKey<?, ? extends Feed> key, Feed source) {
        super((ElementKey<?, ? extends Source>)key, (Element)source);
        this.feedState = source.feedState;
    }

    public Service getService() {
        return this.feedState.service;
    }

    @Override
    public void setService(Service v) {
        this.feedState.service = v;
        for (Entry entry : this.getEntries()) {
            entry.setService(v);
        }
    }

    @Override
    public boolean getCanPost() {
        return this.feedState.canPost;
    }

    @Override
    public void setCanPost(boolean v) {
        this.feedState.canPost = v;
    }

    @Override
    public String getVersionId() {
        return this.feedState.versionId;
    }

    @Override
    public void setVersionId(String v) {
        this.feedState.versionId = v;
    }

    @Override
    public String getEtag() {
        return this.getAttributeValue(GdAttributes.ETAG);
    }

    @Override
    public void setEtag(String v) {
        this.setAttributeValue(GdAttributes.ETAG, (Object)v);
    }

    @Override
    public String getKind() {
        return this.getAttributeValue(GdAttributes.KIND);
    }

    @Override
    public void setKind(String v) {
        this.setAttributeValue(GdAttributes.KIND, (Object)v);
    }

    public String getSelectedFields() {
        return this.getAttributeValue(GdAttributes.FIELDS);
    }

    public void setSelectedFields(String v) {
        this.setAttributeValue(GdAttributes.FIELDS, (Object)v);
    }

    public URI getXmlBase() {
        return this.getAttributeValue(XML_BASE);
    }

    public void setXmlBase(URI v) {
        this.setAttributeValue(XML_BASE, (Object)v);
    }

    @Override
    public int getTotalResults() {
        Integer v = this.getElementValue(TOTAL_RESULTS);
        if (v == null) {
            return -1;
        }
        return v;
    }

    @Override
    public void setTotalResults(int v) {
        if (v != -1) {
            this.setElement(TOTAL_RESULTS, new Element(TOTAL_RESULTS).setTextValue(v));
        } else {
            this.removeElement(TOTAL_RESULTS);
        }
    }

    @Override
    public int getStartIndex() {
        Integer v = this.getElementValue(START_INDEX);
        if (v == null) {
            return -1;
        }
        return v;
    }

    @Override
    public void setStartIndex(int v) {
        if (v != -1) {
            this.setElement(START_INDEX, new Element(START_INDEX).setTextValue(v));
        } else {
            this.removeElement(START_INDEX);
        }
    }

    @Override
    public int getItemsPerPage() {
        Integer v = this.getElementValue(ITEMS_PER_PAGE);
        if (v == null) {
            return -1;
        }
        return v;
    }

    @Override
    public void setItemsPerPage(int v) {
        if (v != -1) {
            this.setElement(ITEMS_PER_PAGE, new Element(ITEMS_PER_PAGE).setTextValue(v));
        } else {
            this.removeElement(ITEMS_PER_PAGE);
        }
    }

    public List<? extends Entry> getEntries() {
        return this.getElements(Entry.KEY);
    }

    protected <T extends Entry> List<T> getEntries(ElementKey<?, T> key) {
        return this.getElements(key);
    }

    public void setEntries(Collection<? extends Entry> entries) {
        this.clearEntries();
        for (Entry entry : entries) {
            this.addElement(Entry.KEY, (Element)entry);
        }
    }

    public void clearEntries() {
        this.removeElement(Entry.KEY);
    }

    public void addEntry(Entry entry) {
        this.addElement(entry);
    }

    public boolean removeEntry(Entry entry) {
        return this.removeElement(Entry.KEY, entry);
    }

    @Override
    public Entry createEntry() {
        return this.createEntry(Entry.KEY);
    }

    public <E extends Entry> E createEntry(ElementKey<?, E> entryKey) {
        Entry entry;
        try {
            entry = (Entry)Element.createElement(entryKey);
        }
        catch (ContentCreationException cce) {
            throw new IllegalStateException(cce);
        }
        if (this.feedState.service != null) {
            entry.setService(this.feedState.service);
        }
        return (E)entry;
    }

    @Override
    public Link getEntryPostLink() {
        ILink postLink = this.getLink("http://schemas.google.com/g/2005#post", ILink.Type.ATOM);
        return postLink;
    }

    @Override
    public Link getSelfLink() {
        ILink postLink = this.getLink("self", ILink.Type.ATOM);
        return postLink;
    }

    @Override
    public Link getNextLink() {
        return this.getLink("next", ILink.Type.ATOM);
    }

    @Override
    public Link getPreviousLink() {
        return this.getLink("previous", ILink.Type.ATOM);
    }

    @Override
    public Link getFeedBatchLink() {
        return this.getLink("http://schemas.google.com/g/2005#batch", ILink.Type.ATOM);
    }

    public Feed getSelf() throws IOException, ServiceException {
        if (this.feedState.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.feedNotAssociated);
        }
        Link selfLink = this.getSelfLink();
        if (selfLink == null) {
            throw new UnsupportedOperationException("Feed cannot be retrieved");
        }
        URL feedUrl = selfLink.getHrefUri().toURL();
        try {
            String etag = this.getEtag();
            if (etag != null) {
                return (Feed)this.feedState.service.getFeed(feedUrl, this.getClass(), etag);
            }
            return (Feed)this.feedState.service.getFeed(feedUrl, this.getClass(), this.getUpdated());
        }
        catch (NotModifiedException e) {
            return this;
        }
    }

    @Override
    public void removeLinks() {
        this.removeElement(Link.KEY);
    }

    public <T extends Entry> T insert(T newEntry) throws ServiceException, IOException {
        if (this.feedState.service == null) {
            throw new ServiceException(CoreErrorDomain.ERR.entryNotAssociated);
        }
        Link postLink = this.getEntryPostLink();
        if (postLink == null) {
            throw new UnsupportedOperationException("Media cannot be inserted");
        }
        URL postUrl = postLink.getHrefUri().toURL();
        return this.feedState.service.insert(postUrl, newEntry);
    }

    @Override
    protected Element narrow(ElementMetadata<?, ?> meta, ValidationContext vc) {
        String kind = Kinds.getElementKind(this);
        if (kind != null) {
            return this.adapt(this, meta, kind);
        }
        return super.narrow(meta, vc);
    }

    @Override
    public Element resolve(ElementMetadata<?, ?> metadata, ValidationContext vc) {
        this.feedState.canPost = this.getEntryPostLink() != null;
        return super.resolve(metadata, vc);
    }

    public <T extends Entry> List<T> getEntries(Class<T> returnClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (Entry entry : this.getEntries()) {
            if (!returnClass.isInstance(entry)) continue;
            result.add(returnClass.cast(entry));
        }
        return result;
    }

    protected static class FeedState {
        public Service service;
        public boolean canPost = true;
        public String versionId;

        protected FeedState() {
        }
    }
}

