/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  $Id: lookup.js 361 2007-03-16 14:55:48Z hikarin $
 *
 *  @require zeromin2.js
 *  @require domLib.js
 *  @require domTT.js
 *
 */

var Zeromin2;
if (!Zeromin2) Zeromin2 = {};

Zeromin2.lookup = (function(){
    var seen_ = {};
    return function( formElement, ip, element, event ) {
    var buildTooltip = function( rs, ip, element, event ) {
        var content = ip + " <=> " + rs.resolved
            + " (" + rs.country + ")<br>";
        var dnsbl = rs.listed;
        for ( var i in dnsbl ) {
            content += dnsbl[i] ? "×" : "○";
            content += ' ' + i + "<br>";
        }
        domTT_activate(
            element, event, "content",
            content, "type", "velcro"
        );
    };
    if (!/^\d+\.\d+\.\d+\.\d+$/.test(ip)) return;
    var cache = seen_[ip];
    if (cache) {
        buildTooltip( cache, ip, element, event );
        return;
    }
    var matchedElement = jQuery("a:contains('" + ip + "')");
    matchedElement.css({ "color": "green" });
    Zeromin2.sendQueryAsync( formElement,
        { "class": "log", "method": "lookup", "ip": ip },
        function(data) {
            var entry = data.Entries;
            seen_[ip] = entry;
            matchedElement.css({ "color": "red" });
        } );
    };
})();
