#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: setting.pm 390 2007-03-20 14:06:06Z hikarin $
#

package Zeromin2::App::setting;

use strict;
use Zeromin::Setting qw();

sub load {
    my ($zApp) = @_;
    $zApp->privilege( 'can_enter_setting_section', 1 )
        or return $zApp->return_value(1);

    my ( $unijp, $encoding ) = $zApp->unijp();
    my $zBBS     = $zApp->bbs();
    my $zSetting = Zeromin::Setting->new($zBBS);
    my $zUser    = $zApp->user();
    my $param    = {};
    $zSetting->load();

    for my $key ( @{ $zSetting->keyset(1) } ) {
        my $priv_meth = $zSetting->get_require_privilege($key);
        my $value = $zSetting->get_normalized( $key, $unijp );
        $value =~ tr/,/\n/;
        %$param = (
            %$param,
            "${key}_type"      => $zSetting->get_type($key),
            "${key}_value"     => $value,
            "${key}_privilege" => $zUser->$priv_meth,
            "${key}_${value}"  => 1,
        );
    }

    $zApp->add_template_param($param);
    return $zApp->return_value(0);
}

*load_color = \&load;

*load_restrict = \&load;

*load_other = \&load;

*load_upload = \&load;

#sub save { _save( [ 'BBS_MODE', 'BBS_SUBTITLE', 'BBS_TITLE' ], @_ ) }

sub save { _save( [], @_ ) }

sub _save {
    my ( $spec_keys, $zApp ) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( 'can_enter_setting_section', 1 )
        or return $zApp->return_value(1);

    my $iRequest = $zApp->request();
    my $zSetting = Zeromin::Setting->new( $zApp->bbs() );
    my $zUser    = $zApp->user();
    my @keys     = @$spec_keys ? @$spec_keys : $iRequest->param('setting');
    my ( $ok, $ng ) = ( 0, 0 );
    my ( $unijp, $encoding ) = $zApp->unijp();
    for my $key (@keys) {
        my $priv_meth = $zSetting->get_require_privilege($key);
        if ( !$zUser->$priv_meth ) {
            $zApp->logger( 0,
                'CANNOT CHANGE SETTING.TXT WITHOUT PRIVILEGE: %s', [$key], );
            $ng++;
            next;
        }
        my $value = $iRequest->param($key);
        my $old   = $zSetting->get($key);
        $old eq $value and next;
        $zSetting->set( $key, $unijp->set( $value, 'utf8' )->$encoding() );
        $zApp->logger(
            1,
            'MODIFIED SETTING.TXT: from %s to %s on %s',
            [ $unijp->set( $old, $encoding )->get(), $value, $key ],
        );
        $ok++;
    }

    $ok and $zSetting->save(0);
    return $zApp->return_value( ( $ng ? 1 : 0 ), $ok );
}

1;
__END__
