#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: migrate.pm 610 2007-05-09 14:49:15Z hikarin $
#

package Zeromin2::App::migrate;

use strict;
use Zeromin::App::migrate qw();

sub load {
    my ($zApp) = @_;
    $zApp->privilege(undef) or return $zApp->return_value(1);
    return $zApp->return_value(0);
}

sub save {
    my ($zApp) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    my $zUser = $zApp->user();

    my $ret;
    my $iRequest = $zApp->request();
    if ( $iRequest->param('archive') ) {
        $zUser->can_create_archive() or return $zApp->return_value(1);
        $zUser->can_remove_archive() or return $zApp->return_value(1);
        $zUser->can_update_archive() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::archive($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('pool') ) {
        $zUser->can_create_pool()  or return $zApp->return_value(1);
        $zUser->can_recover_pool() or return $zApp->return_value(1);
        $zUser->can_remove_pool()  or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::pool($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('banner') ) {
        $zUser->can_edit_banner() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::banner($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('category') ) {
        $zUser->can_add_category()    or return $zApp->return_value(1);
        $zUser->can_edit_category()   or return $zApp->return_value(1);
        $zUser->can_remove_category() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::category($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('user') ) {
        $zUser->can_add_category()    or return $zApp->return_value(1);
        $zUser->can_edit_category()   or return $zApp->return_value(1);
        $zUser->can_remove_category() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::user($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('cap') ) {
        $zUser->can_create_cap() or return $zApp->return_value(1);
        $zUser->can_edit_cap()   or return $zApp->return_value(1);
        $zUser->can_remove_cap() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::cap($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('hostlog') ) {
        $zUser->can_create_bbs()      or return $zApp->return_value(1);
        $zUser->can_remove_bbs()      or return $zApp->return_value(1);
        $zUser->can_view_thread_log() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::hostlog($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    if ( $iRequest->param('threadlog') ) {
        $zUser->can_create_bbs()      or return $zApp->return_value(1);
        $zUser->can_remove_bbs()      or return $zApp->return_value(1);
        $zUser->can_view_create_log() or return $zApp->return_value(1);
        $ret = Zeromin::App::migrate::threadlog($zApp);
        $ret->{code} and return $zApp->return_value( $ret->{code} );
    }
    return $zApp->return_value(0);
}

1;
__END__
