#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Truncate.pm 802 2007-06-10 12:47:54Z hikarin $
#

package Img0ch::Plugin::Rewrite::Truncate;

use strict;
use Img0ch::Setting qw();

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig  = $iBBS->get_kernel()->get_config();
    my $iSetting = Img0ch::Setting->new($iBBS);
    my $xhtml_br = $iConfig->get('EnableXHTMLBreak');
    my $renderer = $iConfig->get('Renderer') || 'read.cgi';
    my $bbs_dir  = $iBBS->get_name();
    my $url_to_renderer;

    if ( $iConfig->get_int('UseQueryString') ) {
        my $path
            = join( '/', Img0ch::Request->get_app_uri2($iConfig), $renderer )
            . '?bbs='
            . $iBBS->get_name() . '&key=';
        $url_to_renderer = sub {
            my ( $key, $resno ) = @_;
            return $path . $key . '&res=' . $resno;
        };
    }
    else {
        my $path
            = join( '/', Img0ch::Request->get_app_uri2($iConfig), $renderer )
            . ( $iConfig->get('RendererSeparator') || '/' )
            . $iBBS->get_name();
        $url_to_renderer = sub {
            my ( $key, $resno ) = @_;
            return join '/', $path, $key, $resno;
        };
    }

    bless {
        break_tag => $xhtml_br ? '<br />' : '<br>',
        break_tag_clear => $xhtml_br
        ? '<br class="clear" />'
        : '<br class="clear">',
        max_line_at_index => ( $iSetting->get_int('BBS_LINE_NUMBER') || 1 ),
        max_line_at_mobile => $iSetting->get_int('BBS_MB_LINE_NUMBER'),
        url_to_renderer    => $url_to_renderer,
    }, $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my $break         = $iObject->{break_tag};
    my $line_max      = $iObject->{max_line_at_index};
    my @splitted_text = split m{<br\s?\/?>}xms, $$text;

    if ( @splitted_text > $line_max ) {
        my @new_text;
        for ( my $i = 0; $i <= $line_max - 1; $i++ ) {
            push @new_text, $splitted_text[$i], $break;
        }
        push @new_text, '<span style="color:green">',
            pack( 'C*',
            0x28, 0x8f, 0xc8, 0x97, 0xaa, 0x82, 0xb3, 0x82, 0xea,
            0x82, 0xdc, 0x82, 0xb5, 0x82, 0xbd, 0x81, 0x45, 0x81,
            0x45, 0x91, 0x53, 0x82, 0xc4, 0x82, 0xf0, 0x93, 0xc7,
            0x82, 0xde, 0x82, 0xc9, 0x82, 0xcd, ),
            '<a href="', $iObject->{url_to_renderer}->( $key, $resno ),
            '" onclick="redir(this)">', pack( 'C*', 0x82, 0xb1, 0x82, 0xb1 ),
            '</a>',
            pack( 'C*',
            0x82, 0xf0, 0x89, 0x9f, 0x82, 0xb5, 0x82, 0xc4, 0x82,
            0xad, 0x82, 0xbe, 0x82, 0xb3, 0x82, 0xa2, 0x29, ),
            '</span>', $iObject->{break_tag_clear};
        $$text = join '', @new_text;
    }
    return;
}

my $truncated_mobile = pack 'C*', ( 0x8f, 0xc8 );

sub from_mobile {
    my ( $iObject, $key, $count, $resno, $text, $param ) = @_;
    ( $param->{br2nl} or $param->{single} ) and return;

    my $line_max = $param->{line} || $iObject->{max_line_at_mobile};
    my @splitted_text          = split m{<br\s?/?>}xms, $$text;
    my $splitted_text_line_num = scalar @splitted_text;
    my $url                    = $param->{url} || '';
    $url and $url .= '/' . $key . '/';

    if ( $splitted_text_line_num > $line_max ) {
        my @new_text;
        for ( my $i = 0; $i <= $line_max - 1; $i++ ) {
            push @new_text, $splitted_text[$i], '<br>';
        }
        push @new_text, '<a href=', $url, $resno, '>', $truncated_mobile,
            $splitted_text_line_num, '</a>';
        $$text = join '', @new_text;
    }
    return;
}

1;
__END__
