#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Category.pm 1102 2007-09-10 14:31:36Z hikarin $
#

package Zeromin2::Translate::Img0ch::v2::Category;

use strict;
use Zeromin::Category qw();

sub work {
    my ( $zClass, $iKernel ) = @_;

    my $zCat = Zeromin::Category->new($iKernel);
    my $base = $iKernel->get_config()->get('BBSPath');
    my $path = $base . '/test/info/category.cgi';

    -r $path or return { code => 0, category => 0 };
    local ( $!, *FH );

    open *FH, "<${path}"    ## no critic
        or $iKernel->throw_io_exception($path);
    while ( my $line = <FH> ) {
        chomp $line;
        my ( undef, $name ) = split '<>', $line;
        $zCat->add( $iKernel->get_encoded_str( $name, 'utf8', 'sjis' ) );
    }
    close *FH or $iKernel->throw_io_exception($path);
    $zCat->save();

    return { code => 0, category => 1 };
}

1;
__END__
