#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Cap.pm 1102 2007-09-10 14:31:36Z hikarin $
#

package Zeromin2::Translate::Img0ch::v2::Cap;

use strict;
use Zeromin::Cap qw();

sub work {
    my ( $zClass, $iKernel ) = @_;

    my $zCap = Zeromin::Cap->new($iKernel);
    my $base = $iKernel->get_config()->get('BBSPath');
    my $ret  = { code => 0, cap => 0, cgroup => 0 };

    my $cgroup = $base . '/test/info/groupc.cgi';
    if ( -r $cgroup ) {
        require Img0ch::BBS;
        local ( $!, *FH );
        open *FH, "<${cgroup}"    ## no critic
            or $iKernel->throw_io_exception($cgroup);
        while ( my $line = <FH> ) {
            chomp $line;
            my ( $name, $bbs_dir, undef, $rt ) = split '<>', $line;
            $zCap->get_group_id($name) and next;

            my $privilege = 0;
            my $bbs_id
                = Img0ch::BBS->new( $iKernel, { bbs => $bbs_dir } )->get_id();
            _cgroup_update_privilege( \$privilege, $rt );
            $zCap->add_group(
                {   bbs => $bbs_id,
                    name =>
                        $iKernel->get_encoded_str( $name, 'utf8', 'sjis' ),
                    privilege => $privilege
                }
            );
        }
        close *FH or $iKernel->throw_io_exception($cgroup);
        $zCap->save();
        $ret->{cgroup} = 1;
    }

    my $cap = $base . '/test/info/caps.cgi';
    if ( -r $cap ) {
        local ( $!, *FH );
        open *FH, "<${cap}"    ## no critic
            or $iKernel->throw_io_exception($cap);
        while ( my $line = <FH> ) {
            chomp $line;
            my ( undef, $cname, $pass, $gname, undef ) = split '<>', $line;
            $gname = $iKernel->get_encoded_str( $gname, 'utf8', 'sjis' );
            $zCap->add(
                {   name =>
                        $iKernel->get_encoded_str( $cname, undef, 'sjis' ),
                    pass => $pass,
                    gid  => $zCap->get_group_id($gname)
                }
            );
        }
        close *FH or $iKernel->throw_io_exception($cap);
        $zCap->save();
        $ret->{cap} = 1;
    }

    return $ret;
}

sub _cgroup_update_privilege {
    my ( $role, $rt ) = @_;
    my $auth = {};
    my @r = index( $rt, ',' ) >= 0 ? split( ',', $rt ) : ($rt);

    map { $auth->{$_} = 1 } @r;
    $$role = 1;

    map { exists $auth->{$_} or $$role = 0 } ( 1 .. 7 );
    $auth->{15} and $$role += 2;
    $auth->{8}  and $$role += 4;
    $auth->{18} and $$role += 8;
    $auth->{10} and $$role += 16;
    $auth->{11} and $$role += 32;
    $auth->{13} and $$role += 64;
    $auth->{13} and $$role += 128;
    $auth->{15} and $$role += 256;
    $auth->{17} and $$role += 512;

    return;
}

1;
__END__
