#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Storable.pm 1645 2008-02-06 15:40:18Z hikarin $
#

package Img0ch::Maple::Storable;

use strict;
use Storable qw();

sub new {
    my ( $iClass, $iKernel, $path ) = @_;
    bless {
        __data     => {},
        __filename => $path,
        __kernel   => $iKernel,
    }, $iClass;
}

sub load {
    my ( $iRepos, $path ) = @_;
    my $iKernel = $iRepos->{__kernel};
    my $data    = {};

    $path ||= $iRepos->{__filename};
    if ( -r $path and !-z $path ) {
        %{ $iRepos->{__data} } = %{ Storable::retrieve($path) };
    }
    return 1;
}

sub save {
    my ( $iRepos, $path ) = @_;
    my $iKernel = $iRepos->{__kernel};
    my $data    = $iRepos->{__data};

    $path ||= $iRepos->{__filename};
    my $temp = $path . '.tmp';

    eval {
        Storable::lock_nstore( $data, $temp );
        rename $temp, $path or $iKernel->throw_io_exception($path);
    };
    if ( my $exception = $@ ) {
        if ( -e $temp ) {
            unlink $temp or $iKernel->throw_io_exception($temp);
        }
        die $exception, "\n";
    }
    return 1;
}

sub set {
    my ( $iRepos, $key, $value ) = @_;
    $iRepos->{__data}->{$key} = $value;
    return;
}

*set_binary = \&set;

sub get {
    my ( $iRepos, $key ) = @_;
    return $iRepos->{__data}->{$key} || '';
}

*get_binary = \&get;

sub decode_binary { shift; return $_[0] }

sub is_binary_safe {1}

sub get_int { Img0ch::Kernel::intval( $_[0]->get( $_[1] ) ) }

sub remove {
    my ( $iRepos, $key ) = @_;
    return delete $iRepos->{__data}->{$key};
}

sub iterate {
    my ( $iRepos, $code_ref, @args ) = @_;
    my $data = $iRepos->{__data};

    while ( my ( $key, $value ) = each %{$data} ) {
        my $status = $code_ref->( $key, \$value, @args );
        if ( $status > 0 ) {
            $iRepos->set( $key, $value );
        }
        elsif ( $status < 0 ) {
            $iRepos->remove($key);
        }
    }
    return 1;
}

*iterate_binary = \&iterate;

1;
__END__
