#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: VIP.pm 1764 2008-07-21 13:36:09Z hikarin $
#

package Img0ch::Plugin::BBS::VIP;

use strict;
require 'Vip_quality.pl';    ## no critic

sub rewrite {
    my ($iApp)   = @_;
    my $iRequest = $iApp->request();
    my $iBBS     = $iRequest->bbs();
    my $bbs      = $iBBS->get_name();
    my $key      = $iRequest->key();
    my $name     = $iApp->get_name();

    if ( $iApp->is_make_new_thread() ) {
        my $renamed
            = Vip_quality::vip_quality_new_treed( $name, $bbs, $key, );
        if ( $iApp->cap()->can_add_cap_name() ) {
            my $iKernel = $iApp->kernel();
            my $atmark
                = $iKernel->get_encoded_str(
                $iKernel->translate_symbol('Atmark'),
                $iBBS->get_encoding(), 'utf8' );
            $renamed =~ s/\A$atmark//xms;
        }
        $iApp->set_name($renamed);
    }
    else {
        my $mail    = $iApp->get_mail();
        my $comment = $iApp->get_comment();
        my @ret     = Vip_quality::vip_quality( $name, $mail, '', $comment,
            $iRequest->signature(), $bbs, $key, );
        $iApp->set_name( $ret[0] );
        $iApp->set_mail( $ret[1] );
        $iApp->set_comment( $ret[3] );
    }
    return 1;
}

1;
__END__
