#/*
# *  Copyright 2007-2008 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id$
#

package Img0ch::Plugin::Filter::UnNaturalLink;

use strict;

my $A_TAG_RE = qr{
    &lt;[Aa]\s+[Hh][Rr][Ee][Ff]=.*?&gt;
        .*?
    &lt;/[Aa]&gt;
}xms;
my $BB_URL_RE = qr{
    \[url=?.*?\]
        .*?
    \[/url\]
}xms;

sub check {
    my ($iApp) = @_;
    my $comment = $iApp->get_comment();

    if (   $comment =~ $A_TAG_RE
        || $comment =~ $BB_URL_RE )
    {
        $iApp->set_error('INVALID_POST');
        return 0;
    }

    return 1;
}

1;
__END__
