#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: FlipClip.pm 1826 2009-04-08 15:23:25Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::FlipClip;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();

    bless [
        ( $iConfig->get_int('flipclip.width')  || 229 ),
        ( $iConfig->get_int('flipclip.height') || 163 ),
        ( $iConfig->get('EnableXHTMLBreak') ? ' />' : '>' ),
    ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ( $width, $height, $html_close_tag )
        = ( $iObject->[0], $iObject->[1], $iObject->[2] );

    $$text =~ s{
        (?:\<a[^>]+>)?
        http://w?w?w?\.?flipclip\.net/clips/[\w\-]+/([\w\-]+)/?
        (?:\</a>)?
        }
        {<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000"
  codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0"
  width="${width}" height="${height}" align="middle">
<param name="allowScriptAccess" value="sameDomain"${html_close_tag}
<param name="movie" value="http://www.flipclip.net/swf/player/15.swf?c=$1"${html_close_tag}
<param name="quality" value="high"${html_close_tag}
<param name="wmode" value="transparent"${html_close_tag}
<param name="menu" value="false"${html_close_tag}
<param name="flashvars" value="webServiceUrl=http://www.flipclip.net/amf/player&serviceName=FlipClip::AMF::Player&clipKey=$1&uid=m3loves55&fid=$1&flv_url=http://www.flipclip.net/videos/m3loves55/$1.flv"${html_close_tag}
<embed src="http://www.flipclip.net/swf/player/15.swf?c=$1"
  quality="high" bgcolor="#ffffff" wmode="transparent"
  width="${width}" height="${height}" align="middle"
  flashvars="webServiceUrl=http://www.flipclip.net/amf/player&serviceName=FlipClip::AMF::Player&clipKey=$1&uid=m3loves55&fid=$1&flv_url=http://www.flipclip.net/videos/m3loves55/$1.flv"
  allowscriptaccess="sameDomain" type="application/x-shockwave-flash"
  pluginspage="http://www.macromedia.com/go/getflashplayer"${html_close_tag}
</object><br${html_close_tag}}gxms;
    return;
}

*from_read = \&from_bbs;

1;
__END__
