#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Archive.pm 1299 2007-10-06 13:24:47Z hikarin $
#

package Zeromin2::Translate::Img0ch::v2::Archive;

use strict;
use File::Copy qw();
use File::Find qw();
use File::Path qw();
use File::Spec qw();
use Zeromin::Archive qw();
use Zeromin::BBS qw();

sub work {
    my ( $zClass, $iKernel ) = @_;

    my $zBBS = Zeromin::BBS->new( $iKernel, { id => 0 } );
    my $bbs_all = $zBBS->all();
    foreach my $bbs (@$bbs_all) {
        my $iBBS = Img0ch::BBS->new( $iKernel, { id => $bbs->{id} } );
        my $zArchive = Zeromin::Archive->new($iBBS);
        _aggregate( $iKernel, $zArchive, $iBBS );
    }

    return { code => 0, archive => 1 };
}

sub _aggregate {
    my ( $iKernel, $zArchive, $iBBS ) = @_;
    my $base = $iBBS->path('kako');
    -d $base or return;

    opendir my $fh, $base or $iKernel->throw_io_exception($base);
    my @dirs = readdir $fh;
    closedir $fh or $iKernel->throw_io_exception($base);

    my $hash = {};
    for my $dir ( File::Spec->no_upwards(@dirs) ) {
        $dir =~ /\A\d{3,3}\z/xms or next;
        $dir = File::Spec->catdir( $base, $dir );
        File::Find::find(
            {   bydepth  => 1,
                no_chdir => 1,
                untaint  => 1,
                wanted   => sub {
                    my $name = $File::Find::name;
                    -f $name
                        and $name =~ m{/(\d{9,10})\.html\z}xms
                        and $hash->{$1} = $name;
                },
            },
            $dir
        );
        for my $key ( keys %$hash ) {
            my $path = $zArchive->path($key);

            if ( !-d $path ) {
                File::Path::mkpath($path)
                    or $iKernel->throw_io_exception($path);
            }
            my $new_archive_path = "${path}/${key}.html";
            File::Copy::copy( $hash->{$key}, $new_archive_path )
                or $iKernel->throw_io_exception($new_archive_path);

            my $fh = $iKernel->get_read_file_handle($new_archive_path);
            my $content = do { local $/ = undef; <$fh> };
            close $fh or $iKernel->throw_io_exception($new_archive_path);

            $content =~ m{<title>([^<]+)</title>}xms;
            my $subject = $1;
            do {1} while ( $content =~ m/<dt>(\d+)/gxms );
            my $res = $1;

            $zArchive->set( $key, $res, $subject );
        }
        %$hash = ();
    }

    $zArchive->save();
    $zArchive->update();
    return;
}

1;
__END__
