/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 * gtkimmoduleime
 * Copyright (C) 2003 Takuro Ashie
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * $Id: gtkimcontextime.h,v 1.5 2003/05/09 14:05:06 makeinu Exp $
 */

#include <gtk/gtkimcontext.h>

extern GType gtk_type_im_context_ime;

#define GTK_TYPE_IM_CONTEXT_IME            gtk_type_im_context_ime
#define GTK_IM_CONTEXT_IME(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_IM_CONTEXT_IME, GtkIMContextIME))
#define GTK_IM_CONTEXT_IME_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_IM_CONTEXT_IME, GtkIMContextIMEClass))
#define GTK_IS_IM_CONTEXT_IME(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_IM_CONTEXT_IME))
#define GTK_IS_IM_CONTEXT_IME_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_IM_CONTEXT_IME))
#define GTK_IM_CONTEXT_IME_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GTK_TYPE_IM_CONTEXT_IME, GtkIMContextIMEClass))

typedef struct _GtkIMContextIME        GtkIMContextIME;
typedef struct _GtkIMContextIMEPrivate GtkIMContextIMEPrivate;
typedef struct _GtkIMContextIMEClass   GtkIMContextIMEClass;

typedef enum {
    GTK_IM_CONTEXT_IME_PREEDIT_IME,
    GTK_IM_CONTEXT_IME_PREEDIT_GTK,
} GtkIMContextIMEPreeditMode;

struct _GtkIMContextIME
{
    GtkIMContext  object;

    GdkWindow    *client_window;
    gint          preedit_mode;
    gboolean      preediting;
    gboolean      opened;

    GtkIMContextIMEPrivate *priv;
};

struct _GtkIMContextIMEClass
{
    GtkIMContextClass parent_class;
};


void          gtk_im_context_ime_register_type (GTypeModule *type_module);
GtkIMContext *gtk_im_context_ime_new           (void);
