/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imodoki.extractor;

import jp.sourceforge.imodoki.extractor.Mark;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;

public class Remover {
    private Mark m_mark;

    public Remover(Mark mark) {
        this.m_mark = mark;
    }

    public JavaClass processClass(JavaClass clazz) {
        String className = clazz.getClassName();
        ConstantPoolGen origCpGen = new ConstantPoolGen(clazz.getConstantPool());
        ClassGen classGen = new ClassGen(className, clazz.getSuperclassName(), className.replace('.', '/'), clazz.getAccessFlags(), clazz.getInterfaceNames());
        ConstantPoolGen cpGen = classGen.getConstantPool();
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            String signature;
            Method method = methods[i];
            String name = method.getName();
            if (this.m_mark.isMethodMarked(className, name, signature = method.getSignature())) {
                classGen.addMethod(this.processMethod(method, origCpGen, cpGen));
            }
            ++i;
        }
        Field[] fields = clazz.getFields();
        int i2 = 0;
        while (i2 < fields.length) {
            Field field = fields[i2];
            String name = field.getName();
            if (this.m_mark.isFieldMarked(className, name)) {
                classGen.addField(this.processField(field, origCpGen, cpGen));
            }
            ++i2;
        }
        return classGen.getJavaClass();
    }

    private Method processMethod(Method method, ConstantPoolGen origCpGen, ConstantPoolGen cpGen) {
        ExceptionTable et;
        InstructionList il = null;
        Code code = method.getCode();
        if (code != null) {
            il = this.processInstructionList(code.getCode(), origCpGen, cpGen);
        }
        MethodGen methodGen = new MethodGen(method.getAccessFlags(), Type.getReturnType((String)method.getSignature()), Type.getArgumentTypes((String)method.getSignature()), null, method.getName(), null, il, cpGen);
        methodGen.stripAttributes(true);
        if (code != null) {
            methodGen.setMaxStack(code.getMaxStack());
            methodGen.setMaxLocals(code.getMaxLocals());
            CodeException[] ces = code.getExceptionTable();
            if (ces != null) {
                int j = 0;
                while (j < ces.length) {
                    InstructionHandle end;
                    CodeException ce = ces[j];
                    int type = ce.getCatchType();
                    ObjectType c_type = null;
                    if (type > 0) {
                        String cen = method.getConstantPool().getConstantString(type, (byte)7);
                        c_type = new ObjectType(cen);
                    }
                    int end_pc = ce.getEndPC();
                    int length = code.getCode().length;
                    if (length == end_pc) {
                        end = il.getEnd();
                    } else {
                        end = il.findHandle(end_pc);
                        end = end.getPrev();
                    }
                    methodGen.addExceptionHandler(il.findHandle(ce.getStartPC()), end, il.findHandle(ce.getHandlerPC()), c_type);
                    ++j;
                }
            }
        }
        if ((et = method.getExceptionTable()) != null) {
            String[] names = et.getExceptionNames();
            int j = 0;
            while (j < names.length) {
                methodGen.addException(names[j]);
                ++j;
            }
        }
        return methodGen.getMethod();
    }

    private InstructionList processInstructionList(byte[] code, ConstantPoolGen origCpGen, ConstantPoolGen cpGen) {
        InstructionList il = new InstructionList(code);
        il.replaceConstantPool(origCpGen, cpGen);
        return il;
    }

    private Field processField(Field field, ConstantPoolGen origCpGen, ConstantPoolGen cpGen) {
        FieldGen fieldGen = new FieldGen(field.getAccessFlags(), Type.getType((String)field.getSignature()), field.getName(), cpGen);
        ConstantValue cv = field.getConstantValue();
        if (cv != null) {
            Constant val = origCpGen.getConstant(cv.getConstantValueIndex());
            int idx = cpGen.addConstant(val, origCpGen);
            ConstantValue newcv = new ConstantValue(cpGen.addUtf8("ConstantValue"), 2, idx, cpGen.getConstantPool());
            fieldGen.addAttribute((Attribute)newcv);
        }
        return fieldGen.getField();
    }
}

