/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imodoki.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.imodoki.extractor.ClassPath;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class Repository {
    private ClassPath m_classPath;
    private Map m_classes;

    public Repository(String classPath) {
        this.m_classPath = new ClassPath(classPath);
        this.m_classes = new HashMap();
    }

    public JavaClass lookupClass(String name) throws IOException {
        JavaClass cls = (JavaClass)this.m_classes.get(name = name.replace('/', '.'));
        if (cls == null) {
            InputStream is = this.m_classPath.getInputStream(name);
            ClassParser parser = new ClassParser(is, name);
            cls = parser.parse();
            this.m_classes.put(name, cls);
        }
        return cls;
    }

    public JavaClass[] getClasses() {
        JavaClass[] classes = this.m_classes.values().toArray(new JavaClass[0]);
        return classes;
    }

    public void clear() {
        this.m_classes.clear();
    }

    public void close() {
        try {
            this.m_classPath.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

