@echo off

REM   Copyright (c) 2001-2002 The Apache Software Foundation.  All rights
REM   reserved.

if "%OS%"=="Windows_NT" @setlocal

rem %~dp0 is expanded pathname of the current script under NT
set DEFAULT_IMODOKI_HOME=%~dp0..

if "%IMODOKI_HOME%"=="" set IMODOKI_HOME=%DEFAULT_IMODOKI_HOME%
set DEFAULT_IMODOKI_HOME=

rem Slurp the command line arguments. This loop allows for an unlimited number
rem of arguments (up to the command line limit, anyway).
set ANT_CMD_LINE_ARGS=%1
if ""%1""=="""" goto doneStart
shift
:setupArgs
if ""%1""=="""" goto doneStart
set ANT_CMD_LINE_ARGS=%ANT_CMD_LINE_ARGS% %1
shift
goto setupArgs
rem This label provides a place for the argument list loop to break out 
rem and for NT handling to skip to.
:doneStart

rem find IMODOKI_HOME if it does not exist due to either an invalid value passed
rem by the user or the %0 problem on Windows 9x
if exist "%IMODOKI_HOME%" goto checkJava

rem check for ant in Program Files on system drive
if not exist "%SystemDrive%\Program Files\imodoki" goto checkSystemDrive
set IMODOKI_HOME=%SystemDrive%\Program Files\imodoki
goto checkJava

:checkSystemDrive
rem check for ant in root directory of system drive
if not exist %SystemDrive%\imodoki\nul goto checkCDrive
set IMODOKI_HOME=%SystemDrive%\imodoki
goto checkJava

:checkCDrive
rem check for ant in C:\ant for Win9X users
if not exist C:\imodoki\nul goto noAntHome
set IMODOKI_HOME=C:\imodoki
goto checkJava

:noAntHome
echo IMODOKI_HOME is set incorrectly or ant could not be located. Please set IMODOKI_HOME.
goto end

:checkJava
set LOCALCLASSPATH=%CLASSPATH%
for %%i in ("%IMODOKI_HOME%\lib\*.jar") do call "%IMODOKI_HOME%\bin\lcp.bat" %%i

if "%JAVA_HOME%" == "" goto noJavaHome
if not exist "%JAVA_HOME%\bin\java.exe" goto noJavaHome
set _JAVACMD=%JAVA_HOME%\bin\java.exe
if exist "%JAVA_HOME%\lib\tools.jar" call "%IMODOKI_HOME%\bin\lcp.bat" "%JAVA_HOME%\lib\tools.jar"
if exist "%JAVA_HOME%\lib\classes.zip" call "%IMODOKI_HOME%\bin\lcp.bat" "%JAVA_HOME%\lib\classes.zip"
goto runAnt

:noJavaHome
set _JAVACMD=java.exe
echo.
echo Warning: JAVA_HOME environment variable is not set.
echo   If build fails because sun.* classes could not be found
echo   you will need to set the JAVA_HOME environment variable
echo   to the installation directory of java.
echo.

:runAnt
set EXTTOOLS_DIR=%IMODOKI_HOME%\ext-tools
call "%IMODOKI_HOME%\bin\lcp.bat" "%IMODOKI_HOME%\converter\classes"
"%_JAVACMD%" -classpath "%LOCALCLASSPATH%" "-Dimodoki.exttools.dir=%EXTTOOLS_DIR%" jp.sourceforge.imodoki.shrinker.Shrinker %ANT_CMD_LINE_ARGS%

:end
set LOCALCLASSPATH=
set _JAVACMD=
set ANT_CMD_LINE_ARGS=
set EXTTOOLS_DIR=

if "%OS%"=="Windows_NT" @endlocal

:mainEnd
