/*
 * $Id: MIDPCanvas.java,v 1.4 2003/04/06 01:50:47 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.nttdocomo.ui;

class MIDPCanvas extends javax.microedition.lcdui.Canvas
    implements javax.microedition.lcdui.CommandListener {

    private Canvas m_canvas;
    private Graphics m_graphics;
    private javax.microedition.lcdui.Image m_backBuffer;
    private final Object m_keyEventLock = new Object();

    /* com.nttdocomo.ui.Canvas 黲Ȥ */
    int m_keypadState;

    public MIDPCanvas(Canvas canvas) {
        m_canvas = canvas;
        m_graphics = new Graphics(this, canvas);
//#DOUBLE_BUFFERING{
        m_backBuffer = javax.microedition.lcdui.Image.createImage(getWidth(), getHeight());
        m_graphics.setMIDPGraphics(m_backBuffer.getGraphics());
//#DOUBLE_BUFFERING}
        setCommandListener(this);
    }

    protected void keyPressed(int keyCode) {
        int code = convertKeyCode(keyCode);
        synchronized (m_keyEventLock) {
            m_keypadState |= (1 << code);
            m_canvas.processEvent(Display.KEY_PRESSED_EVENT, code);
        }
    }

    protected void keyReleased(int keyCode) {
        int code = convertKeyCode(keyCode);
        synchronized (m_keyEventLock) {
            m_keypadState &= ~(1 << code);
            m_canvas.processEvent(Display.KEY_RELEASED_EVENT, code);
        }
    }

    protected void paint(javax.microedition.lcdui.Graphics g) {
//#DOUBLE_BUFFERING{
        /* ΢̤褹 */
        m_graphics.m_systemLock = true;
        m_canvas.paint(m_graphics);
        m_graphics.m_systemLock = false;
        /* ΢̤Ƥ g  */
        g.drawImage(m_backBuffer, 0, 0,
                    (javax.microedition.lcdui.Graphics.TOP |
                     javax.microedition.lcdui.Graphics.LEFT));
//#}DOUBLE_BUFFERING{
//#DOUBLE_BUFFERING:        m_graphics.setMIDPGraphics(g);
//#DOUBLE_BUFFERING:        m_canvas.paint(m_graphics);
//#DOUBLE_BUFFERING:        m_graphics.dispose();
//#DOUBLE_BUFFERING}
    }

    public void commandAction(javax.microedition.lcdui.Command c,
                              javax.microedition.lcdui.Displayable d) {
        int code;

        if (c == m_canvas.m_commandSoftKeys[0]) {
            code = Display.KEY_SOFT1;
        } else {    /* SoftKey2 */
            code = Display.KEY_SOFT2;
        }

        m_keypadState |= (1 << code);
        synchronized (m_keyEventLock) {
            m_canvas.processEvent(Display.KEY_PRESSED_EVENT, code);
        }
        m_keypadState &= ~(1 << code);
        synchronized (m_keyEventLock) {
            m_canvas.processEvent(Display.KEY_RELEASED_EVENT, code);
        }
    }

    /* Canvas ƤФ */
    Graphics getGraphics() {
        return m_graphics;
    }

    /**
     * MIDP Υɤ DoJa ΥɤѴ
     *
     * : եȥ CommandListener ǽ
     */
    private int convertKeyCode(int keyCode) {
        switch (keyCode) {
        case KEY_NUM0:   return Display.KEY_0;
        case KEY_NUM1:   return Display.KEY_1;
        case KEY_NUM2:   return Display.KEY_2;
        case KEY_NUM3:   return Display.KEY_3;
        case KEY_NUM4:   return Display.KEY_4;
        case KEY_NUM5:   return Display.KEY_5;
        case KEY_NUM6:   return Display.KEY_6;
        case KEY_NUM7:   return Display.KEY_7;
        case KEY_NUM8:   return Display.KEY_8;
        case KEY_NUM9:   return Display.KEY_9;
        case KEY_POUND:  return Display.KEY_POUND;
        case KEY_STAR:   return Display.KEY_ASTERISK;
        default:
            try {
                /* /򥭡  GameAction ѤȽ */
                /* äȥȥå */
                int action = getGameAction(keyCode);
                switch (action) {
                case LEFT:   return Display.KEY_LEFT;
                case UP:     return Display.KEY_UP;
                case RIGHT:  return Display.KEY_RIGHT;
                case DOWN:   return Display.KEY_DOWN;
                case FIRE:   return Display.KEY_SELECT;
                default:     return Display.MIN_VENDOR_KEY;
                }
            } catch (Exception e) {
                /* ϤؤϤϤʤȻפ
                   ezplus ȥꥢ getGameAction() Ϥ
                   㳰ꤲƤޤ */
                /* ʤߤ IllegalArgumentException Ƚ񤯤
                   Exception Τۤ饹ե뤬ƺѤࡣ */
                return Display.MIN_VENDOR_KEY;
            }
        }
    }
}
