/*
 * $Id: MediaImageImpl.java,v 1.4 2003/04/06 01:50:47 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.nttdocomo.ui;

import java.io.*;
import javax.microedition.io.InputConnection;
import com.nttdocomo.io.ConnectionException;
import imodoki.wrapper.Connector;

class MediaImageImpl implements MediaImage {
    private String m_location;
    private Image m_image;

    MediaImageImpl(String location) {
        m_location = location;
        m_image = null;
    }

    public void use() throws ConnectionException, UIException {
        try {
            if (m_location.startsWith("resource://")) {
                /* ʥ(ΤϤ)ΤΥ硼ȥå */
                javax.microedition.lcdui.Image img =
                    javax.microedition.lcdui.Image.createImage(m_location.substring(11));
                    
                m_image = new Image(img);
            } else {
                useImplGeneric();
            }
        } catch (IOException ioe) {
            /* ꥽ʤ or ɤ߹߼ or ǥɤ˼ */
            throw new ConnectionException(ConnectionException.NO_RESOURCE);
        }
    }

    /* use() Ѽ */
    private void useImplGeneric() throws IOException, UIException {
        /* ȥ꡼फեΤɤ߹ */
        InputStream is = Connector.openInputStream(m_location);
        byte[] buf = new byte[512];
        int len = 0, rdlen;
        while ((rdlen = is.read(buf, len, buf.length - len)) != -1) {
            len += rdlen;
            if (len >= buf.length) {
                byte[] tmp = new byte[buf.length * 2];
                System.arraycopy(buf, 0, tmp, 0, len);
                buf = tmp;
            }
        }
        is.close();

        javax.microedition.lcdui.Image img;
        try {
            img = javax.microedition.lcdui.Image.createImage(buf, 0, len);
        } catch (IllegalArgumentException iae) {
            throw new UIException(UIException.UNSUPPORTED_FORMAT);
        }
        m_image = new Image(img);
    }

    public void unuse() throws UIException {
        if(m_image == null)
            throw new UIException(UIException.ILLEGAL_STATE);
    }
    
    public void dispose() {
        m_image.dispose();
        m_image = null;
    }

    public int getWidth() {
        if(m_image == null)
            throw new UIException(UIException.ILLEGAL_STATE);

        return m_image.getWidth();
    }

    public int getHeight() {
        if(m_image == null)
            throw new UIException(UIException.ILLEGAL_STATE);

        return m_image.getHeight();
    }

    public Image getImage() {
        return m_image;
    }
}
