#!/usr/bin/perl
# Copyright (c) 2003, Influenza. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

# Partial Download Server
# require: mod_perl

# File      ./data/imoogle.20030701
#           ./data/immogle.20030708 <-- New!
#           ./data/wirekids.20030401
#
# example1) query newfile
#   Request   http://akizakura.dyndns.org/cgi-bin/i/loader.cgi?query=imoogle
#   Response  Content-Type: application/octet-stream
#             Content-Length: 4
#             32bit big-endian (20030708)
#
# example1-1) query newfile & download
#   Request   http://akizakura.dyndns.org/cgi-bin/i/loader.cgi?query=imoogle&
#             pos=0&len=4
#   Response  Content-Type: application/octet-stream
#             Content-Length: 4
#             32bit big-endian (20030708)
#             binary data (./data/imoogle.20030708 offset=0 length=4)
#
# example2) partial download
#   Request   http://akizakura.dyndns.org/cgi-bin/i/loader.cgi?file=imoogle.2
#             0030708&pos=0&len=10240
#   Response  Content-Type: application/octet-stream
#             Content-Length: 10240
#             binary data (./data/immogle.20030708 offset=0 length=10240)

$MYNAME = "loader";
$PATH = "./data";
$LOG = "/tmp/loader.log";

$now = time;
if( !defined $EXPIRE_TIME or $now > $EXPIRE_TIME ) {
  $EXPIRE_TIME = $now + 60;
  open LOG, ">>$LOG";
  $curr = select LOG; $| = 1; select $curr;
  &log( "re-scan" );
  &scan;
}

%param = map {
           tr/+/ /; s/%([a-f\d][a-f\d])/chr hex $1/ieg; (/(.*?)=(.*)/);
         } split /&/,$ENV{'QUERY_STRING'};

$result = "";
$agent = $ENV{'HTTP_USER_AGENT'};
if( $agent !~ /(TJ\)?|DOJA_INET_CLIENT)$/ ) {
  &log( "rejected: $agent" );
} elsif( exists $param{'query'} ) {
  $name = $param{'query'};
  $result = pack "N", $FILES{$name};
  if( exists $param{'len'} ) {
    ($pos = $param{'pos'}) or $pos = 0;
    $len = $param{'len'};
    $result .= &download( $name.$FILE{$name}, $pos, $len );
  }
} else {
  $file = $param{'file'};
  ($pos = $param{'pos'}) or $pos = 0;
  ($len = $param{'len'}) or $len = 10240;
  $result = &download( $file, $pos, $len );
}

print "Content-Type: application/octet-stream\r\n";
print "Content-Length: ".length( $result )."\r\n\r\n";
print $result;
&log( &hexdump( $result ) );

#
# Scan directory
#
sub scan {
  %FILES = ();
  unless( opendir DH, $PATH ) {
    &log( "opendir failed: $PATH" );
    return "";
  }
  for( readdir DH ) {
    $FILES{$1} = $2 if /([a-zA-Z\d]+).(\d+)/ && $2 > $FILES{$1};
  }
  closedir DH;
}

#
# Download
#
sub download {
  my ($file, $pos, $len) = @_;

  # sanitize !
  return "" unless $file =~ /^[a-zA-Z\d.]+$/;

  unless( open FH, "$PATH/$file" ) {
    &log( "open failed: $PATH/$file" );
    return "";
  }
  unless( seek FH, $pos, 0 ) {
    &log( "seek failed: $PATH/$file $pos" );
    return "";
  }
  my $buf;
  read FH, $buf, $len or $buf = "";
  close FH;

  return $buf;
}

#
# Logging
#
sub log {
  my $fmt = shift @_;
  my @tm = localtime;
  printf LOG "%04d/%02d/%02d %02d:%02d:%02d $MYNAME(%d) %s\n",
                 $tm[5]+1900, $tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[0], $$,
                 sprintf($fmt, @_);
}

#
# Hex dump (for debug)
#
sub hexdump {
  my $len = length $_[0] or return;
  return join "", unpack( "H8"x(($len + 3) / 4), $_[0] );
}
