/*
 * Copyright (c) 2003, Influenza. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
import com.nttdocomo.ui.*;
import java.util.*;

/**
 * FF11Vsc[
 */
public class iMoogle extends IApplication implements KeyListener, SoftKeyListener, ComponentListener {
    /**
     * L[[1-9*#]ł̑ΏۃR|[lg
     * {^componentAction()ł̎ʗp
     *            Zbg 
     * compo[0]:   1     2     3
     * compo[1]:   4     5     6
     * compo[2]:   7*    8     9#
     * compo[3]: ACe{^
     * compo[4]: Vs{^
     * compo[5]: XV{^
     * compo[6]: ON
     */
    Component[] compo;

    /**
     * ŌɉꂽL[
     * L[CxǧʂC[vƂɗp
     * synchronized( this )ȃubNŃANZX邱
     */
    volatile int lastKey;

    /**
     * 񃊃\[X
     * resource:///str.txt̓e
     * NXt@Cɕ𖄂ߍނƗeʂ邽߁A
     * ł邾\[Xɒǂoقǂ
     */
    static String[] words;

    View f;
    Panel itemPanel;

    public iMoogle() {
    }

    public void start() {
        int i0, i1, i2;
        Item item;
        Recipe recipe;
        int dataVersion;

        // ʕ\LoX
        f = new View();
        Display.setCurrent( f );
        f.progress( "f[^WJ...", 0 );

        Runtime rt = Runtime.getRuntime();
        try {
            // IONX
            Model[] models = new Model[2];
            dataVersion = IO.init( getSourceURL(), models );
            item = (Item)models[0];
            recipe = (Recipe)models[1];
            models = null;

            // \[Xǂݍ
            words = IO.loadWords();

        } catch( Throwable e ) {
            System.out.println( e );
            terminate();
            return;
        }

        int itemNum   = item.getCount();
        int recipeNum = recipe.getCount();
        System.out.println( "items: " + itemNum );
        System.out.println( "recipes: " + recipeNum );
        System.out.println( rt.freeMemory() + "/" + rt.totalMemory() );

        // ACepl쐬
        compo = new Component[7];
        itemPanel = new Panel();
        itemPanel.setTitle( "ACe" );

        itemPanel.add( new Label( "O(v)" ) );
        TextBox nameField = new TextBox( null, 20, 1, TextBox.DISPLAY_ANY );
        nameField.setInputMode( TextBox.KANA );
        itemPanel.add( nameField );

        itemPanel.add( new Label( "JeS 1<2>3" ) );
        ListBox catList = new ListBox( ListBox.CHOICE );
        for( int i = 0; i < 31; i++ )
            catList.append( getCategory( i ) );
        itemPanel.add( catList );

        itemPanel.add( new Label( "Wu 4<5>6" ) );
        ListBox jobList = new ListBox( ListBox.CHOICE );
        for( int i = 0; i < 16; i++ )
            jobList.append( getJob( i ) );
        itemPanel.add( jobList );

        itemPanel.add( new Label( "x" ) );
        TextBox levelField = new TextBox( "1", 3, 1, TextBox.DISPLAY_ANY );
        levelField.setInputMode( TextBox.NUMBER );
        itemPanel.add( levelField );

        Button itemButton = new Button( "[0]" );
        itemPanel.add( itemButton );
        compo[3] = itemButton;

        AnchorButton note = new AnchorButton(
                         "ffrecipẽf[^𗘗pĂĂ܂B" );
        note.setEnabled( false );
        itemPanel.add( note );
        AnchorButton linkButton = new AnchorButton( "ffrecipe" );
        itemPanel.add( linkButton );
        compo[6] = linkButton;

        itemPanel.add( new Label( "(C)2004 Influenza", Label.LEFT ) );
        Button updateButton = new Button( "" + dataVersion + " XV" );
        itemPanel.add( updateButton );
        compo[5] = updateButton;

        itemPanel.setKeyListener( this );
        itemPanel.setSoftKeyListener( this );
        itemPanel.setComponentListener( this );
        itemPanel.setSoftLabel( Frame.SOFT_KEY_1, "ڼ" );
        itemPanel.setSoftLabel( Frame.SOFT_KEY_2, "I" );

        // Vspl쐬
        Panel recipePanel = new Panel();
        recipePanel.setTitle( "Vs" );

        recipePanel.add( new Label( "Mh 1<2>3" ) );
        ListBox guildList = new ListBox( ListBox.CHOICE );
        for( int i = 0; i < 9; i++ )
            guildList.append( getGuild( i ) );
        recipePanel.add( guildList );

        recipePanel.add( new Label( "NX^ 4<5>6" ) );
        ListBox crystalList = new ListBox( ListBox.CHOICE );
        for( int i = 0; i < 9; i++ )
            crystalList.append( getCrystal( i ) );
        recipePanel.add( crystalList );

        recipePanel.add( new Label( "XL" ) );
        TextBox skillField = new TextBox( "1", 3, 1, TextBox.NUMBER );
        recipePanel.add( skillField );

        Button recipeButton = new Button( "[0]" );
        recipePanel.add( recipeButton );
        compo[4] = recipeButton;

        recipePanel.setKeyListener( this );
        recipePanel.setSoftKeyListener( this );
        recipePanel.setComponentListener( this );
        recipePanel.setSoftLabel( Frame.SOFT_KEY_1, "" );
        recipePanel.setSoftLabel( Frame.SOFT_KEY_2, "I" );

        StringBuffer header0 = new StringBuffer();
        short[] result0 = new short[50]; // ACe
        int len0 = 0;                    // ACeʂ̐
        int cur0 = 0;                    // ʂ̃J[\ʒu
        int id0 = 0;                     // I𒆃ACeID

        StringBuffer header1 = new StringBuffer();
        short[] result1 = new short[50]; // Vs
        int len1 = 0;                    // Vsʂ̐
        int cur1 = 0;                    // Vsʂ̃J[\ʒu
        int id1 = 0;                     // I𒆃VsID

        String name = null;
        int category = 0;
        int job = 0;
        int level = 1;
        int guild = 0;
        int crystal = 0;
        int skill = 1;
        levelField.setText( "" + level );

        final int ITEM_PANEL    = 1;
        final int ITEM_LIST     = 2;
        final int ITEM_SEARCH   = 3;
        final int ITEM_DETAIL   = 4;
        final int RECIPE_PANEL  = 5;
        final int RECIPE_LIST   = 6;
        final int RECIPE_SEARCH = 7;
        final int RECIPE_DETAIL = 8;
        int backState = ITEM_PANEL;
        int state = ITEM_PANEL;
        try {
            while( true ) {
                switch( state ) {
                case ITEM_PANEL:
                    System.out.println( "ITEM_PANEL" );
                    compo[0] = catList;
                    compo[1] = jobList;
                    compo[2] = levelField;
                    Display.setCurrent( itemPanel );
                    if( keyWait( item.maxLevel ) == Display.KEY_SOFT1 ) {
                        state = RECIPE_PANEL;
                        continue;
                    }
                    state = ITEM_SEARCH;
                    continue;

                case ITEM_SEARCH:
                    System.out.println( "ITEM_SEARCH" );
                    name = nameField.getText();
                    category = catList.getSelectedIndex();
                    job = jobList.getSelectedIndex();
                    level = Integer.parseInt( levelField.getText() );
                    len0 = item.search( result0, name, category, job, 0, level );
                    header0.delete( 0, header0.length() );
                    if( name != null && name.length() > 0 ) {
                        header0.append( '\'' );
                        header0.append( name );
                        header0.append( '\'' );
                    } else {
                        header0.append( getCategory( category ) );
                    }
                    if( job > 0 ) {
                        header0.append( ' ' );
                        header0.append( getJob( job ) );
                    }
                    if( level > 0 ) {
                        header0.append( ' ' );
                        header0.append( 'L' );
                        header0.append( level );
                    }
                    cur0 = 0;
                    state = ITEM_LIST;
                    continue;

                case ITEM_LIST:
                    System.out.println( "ITEM_LIST" );
                    Display.setCurrent( f );
                    f.setSoftLabel( Frame.SOFT_KEY_1, null );
                    f.setSoftLabel( Frame.SOFT_KEY_2, "߂" );
                    cur0 = f.list( header0.toString(), result0, len0, cur0, item );
                    if( cur0 >= 0 ) {
                        id0 = result0[cur0];
                        state = ITEM_DETAIL;
                        continue;
                    }
                    cur0 += 32; // L[R[hɕϊ
                    if( cur0 == Display.KEY_SOFT2 ) {
                        state = ITEM_PANEL;
                        continue;
                    }
                    operate( cur0, item.maxLevel );
                    state = ITEM_SEARCH;
                    continue;

                case ITEM_DETAIL:
                    System.out.println( "ITEM_DETAIL" );
                    f.setSoftLabel( Frame.SOFT_KEY_1, "ڼ" );
                    if( f.detail( id0, item ) == Display.KEY_SOFT1 ) {
                        // IACe֘ÃVs
                        guild = 0;
                        crystal = 0;
                        skill = 0;
                        backState = ITEM_DETAIL;
                        state = RECIPE_SEARCH;
                        continue;
                    }
                    state = ITEM_LIST;
                    continue;

                case RECIPE_PANEL:
                    System.out.println( "RECIPE_PANEL" );
                    compo[0] = guildList;
                    compo[1] = crystalList;
                    compo[2] = skillField;
                    skillField.setText( "" + skill );
                    Display.setCurrent( recipePanel );
                    if( keyWait( recipe.maxLevel ) == Display.KEY_SOFT1 ) {
                        state = ITEM_PANEL;
                        continue;
                    }
                    id0 = 0;
                    guild = guildList.getSelectedIndex();
                    crystal = crystalList.getSelectedIndex();
                    skill = Integer.parseInt( skillField.getText() );

                    backState = RECIPE_PANEL;
                    state = RECIPE_SEARCH;
                    continue;

                case RECIPE_SEARCH:
                    System.out.println( "RECIPE_SEARCH" );
                    len1 = recipe.search( result1, id0, guild, crystal, skill, 0 );
                    header1.delete( 0, header1.length() );
                    if( id0 > 0 ) {
                        header1.append( '[' );
                        header1.append( item.getName( id0 ) );
                        header1.append( ']' );
                    } else {
                        header1.append( getGuild( guild ) );
                        header1.append( skill );
                        if( crystal > 0 ) {
                            header1.append( '(' );
                            header1.append( getCrystal( crystal ) );
                            header1.append( ')' );
                        }
                    }
                    cur1 = 0;
                    state = RECIPE_LIST;
                    continue;

                case RECIPE_LIST:
                    System.out.println( "RECIPE_LIST" );
                    Display.setCurrent( f );
                    f.setSoftLabel( Frame.SOFT_KEY_1, null );
                    f.setSoftLabel( Frame.SOFT_KEY_2, "߂" );

                    cur1 = f.list( header1.toString(), result1, len1, cur1, recipe );
                    if( cur1 >= 0 ) {
                        id1 = result1[cur1];
                        state = RECIPE_DETAIL;
                        continue;
                    }
                    cur1 += 32; // L[R[hɕϊ
                    if( cur1 == Display.KEY_SOFT2 ) {
                        state = backState;
                        continue;
                    }
                    if( id0 > 0 ) {
                        /* ACeIDw肳ꂽVsł
                           Xg̏ύXȂ */
                        continue;
                    }
                    operate( cur1, recipe.maxLevel );
                    id1 = 0;
                    guild = guildList.getSelectedIndex();
                    crystal = crystalList.getSelectedIndex();
                    skill = Integer.parseInt( skillField.getText() );
                    state = RECIPE_SEARCH;
                    continue;

                case RECIPE_DETAIL:
                    System.out.println( "RECIPE_DETAIL" );
                    f.detail( id1, recipe );
                    state = RECIPE_LIST;
                    continue;
                }
            }
        } catch( Throwable e ) {
            Dialog d = new Dialog( Dialog.DIALOG_ERROR, "ERROR" );
            d.setText( e + ":" + View.trace );
            d.show();
        }
        terminate();
    }

    /**
     * compo
     * @param k L[
     * @param max x̓tB[h̍ől
     * @return kLȒlȂtrue
     */
    public boolean operate( int k, int max ) {
        int inc = 1;
        if( k < Display.KEY_1 || k > Display.KEY_POUND )
            return false;

        if( k == Display.KEY_ASTERISK ) {
            k = Display.KEY_7;
            inc = 10;
        }
        if( k == Display.KEY_POUND ) {
            k = Display.KEY_9;
            inc = 10;
        }

        Component c = compo[(k - 1) / 3];
        if( c instanceof ListBox ) {
            ListBox lb = (ListBox)c;
            max = lb.getItemCount();
            int cur = lb.getSelectedIndex();
            switch( k % 3 ) {
            case 2:
                cur = 0;
                break;
            case 0:
                cur++;
                break;
            case 1:
                cur = cur + max - 1;
                break;
            }
            cur %= max;
            lb.select( cur );
        } else {
            TextBox tb = (TextBox)c;
            max++;
            int cur = 0;
            try {
                cur = Integer.parseInt( tb.getText() );
            } catch( Exception e ) {
            }
            switch( k % 3 ) {
            case 2:
                cur = 1;
                break;
            case 0:
                cur += inc;
                break;
            case 1:
                cur += max - inc;
                break;
            }
            cur %= max;
            tb.setText( "" + cur );
        }
        return true;
    }

    /**
     * L[͑҂
     * L[[1-9*#]̃I[gs[gsA
     * \tgL[1L[0ꂽA
     * @param max x̓tB[h̍ől
     * @return ꂽL[(KEY_SOFT1 or KEY_0)
     */
    public synchronized int keyWait( int max ) {
        final int REPEAT_BEGIN = 300; // L[s[gJn(~b)
        final int REPEAT_PITCH = 80;  // L[s[gԊu(~b)

        while( true ) {
            try {
                wait();

                if( lastKey == Display.KEY_0 || lastKey == Display.KEY_SOFT1 )
                    return lastKey;

                int waitTime = REPEAT_BEGIN;
                while( operate( lastKey, max ) ) {
                    wait( waitTime );
                    waitTime = REPEAT_PITCH;
                }
            } catch( Exception e ) {
                // InterruptedException
            }
        }
    }

    public synchronized void keyPressed( Panel p, int key ) {
        lastKey = key;
        notify();
    }

    public synchronized void keyReleased( Panel p, int key ) {
        lastKey = -1;
        notify();
    }

    public synchronized void softKeyPressed( int key ) {
        if( key == Frame.SOFT_KEY_2 )
            terminate();
        lastKey = Display.KEY_SOFT1;
        notify();
    }

    public void softKeyReleased( int key ) {
    }

    public synchronized void componentAction( Component c, int t, int p ) {
        if( c == compo[3] || c == compo[4] ) {
            lastKey = Display.KEY_0;
            notify();
        }
        if( c == compo[5] ) {
            System.out.println( "f[^XV" );
            try {
                int tag = IO.query();
                if( tag == 0 ) {
                    Dialog d = new Dialog( Dialog.DIALOG_INFO, "XV`FbN" );
                    d.setText( "f[^͍ŐVł" );
                    d.show();
                    return;
                }
                Display.setCurrent( f );
                IO.download( tag );
                Display.setCurrent( itemPanel );
                Dialog d = new Dialog( Dialog.DIALOG_INFO, "XV" );
                d.setText( "ċNĂ" );
                d.show();
                terminate();
            } catch( Exception e ) {
                Dialog d = new Dialog( Dialog.DIALOG_ERROR, "XVs" );
                d.setText( "̉!? " + e.toString() );
                d.show();
            }
        }
        if( c == compo[6] ) {
            String[] args = new String[1];
            args[0] = "http://www.ffrecipe.com/i/";
            this.launch( LAUNCH_BROWSER, args );
        }
    }

    /**
     * ACe̎ʖԂ
     * @param value 1:i
     * @return ʖ
     */
    public static String getCategory( int value ) {
        return words[value];
    }

    /**
     * WuԂ
     * @param value 1:m
     * @return Wu
     */
    public static String getJob( int value ) {
        return words[31 + value];
    }

    /**
     * Vs̃MhԂ
     * @param value 1:b
     * @return Mh
     */
    public static String getGuild( int value ) {
        return words[47 + value];
    }

    /**
     * NX^̑Ԃ
     * @param value 1:
     * @return 
     */
    public static String getCrystal( int value ) {
        return words[56 + value];
    }

    /**
     * 푰Ԃ
     * @param value 1:H
     * @return 푰
     */
    public static String getRace( int value ) {
        return words[65 + value];
    }

    /**
     * OԂ
     * @param value 
     * @return 
     */
    public static String getWords( int value ) {
        return words[74 + value];
    }

}
