# Copyright (c) 2003, Influenza. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
# AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
use Data::Dumper;

($INPUT, $OUTPUT) = @ARGV;

# f[^`̃o[W
$FORMAT_VERSION = 0x01;

@TYPES = qw/s   i   Z   Ў茕 茕 Ў蕀 蕀 芙
            葄 Ў蓁 蓁 Ў螞 螞 y Ǌy |p
            ˌ   Ă ނ                     
                 r      w          w     ̑/;
$num = 0;
$TYPES{$_} = $num++ for @TYPES;
$TYPES{'w'} = $TYPES{'w'};
$TYPES{''} = $TYPES{''};
$TYPES{'r'} = $TYPES{'r'};
$TYPES{''} = $TYPES{'Ă'};

@JOBS = qw/     V i    b   E /;

%RACES = ( 'g' => 0xC0, 'g' => 0x80, 'g' => 0x40,
           'H'  => 0xC0, 'H'  => 0x80, 'H'  => 0x40,
           'd' => 0x30, 'd' => 0x20, 'd' => 0x10,
           'E'  => 0x30, 'E'  => 0x20, 'E'  => 0x10,
           's' => 0x0C, 's' => 0x08, 's' => 0x04,
           'T'  => 0x0C, 'T'  => 0x08, 'T'  => 0x04,
           'l' => 0x02, 'f'   => 0x01,
           'M'  => 0x02, 'G'    => 0x01, 'S' => 0xFF );

@a     = qw/  y   X  /;
@SKILL = qw/b ٖD Bp ؍H  v׍H ׍H ނ  ͔|/;
@a     = qw/fl K k El  ژ^   ㋉El Bl/;

warn "Input file: $INPUT\n";
warn "Output file: $OUTPUT\n";

die ">$0 <input> <output>\n" unless $INPUT && $OUTPUT;

# Phase1 ACef[^\z

%ITEMS = ();
$ITEM_NUM = 0;

open IN, "$INPUT" or die "$INPUT cannot open\n";
@tm = localtime((stat IN)[9]);
$DATA_VERSION = $tm[3] + $tm[4] * 32 + $tm[5] * 32 * 12;
while( <IN> ) {
  ($id,$name,$m0,$m1,$m2,$m3,$m4,$m5,$m6,$m7, $crystal,
   $sk0,$sk1,$sk2,$sk3,$sk4,$sk5,$sk6,$sk7,$sk8,$sk9,
   $min0,$min1,$min2,$min3,$min4,$min5,$min6,$min7,$min8,$min9,
   $max0,$max1,$max2,$max3,$max4,$max5,$max6,$max7,$max8,$max9,
   $hq,$guild,$rank,$desc,$ex,$rare,$stack,$dissolve) = split /,/;
  ($name,$num) = split /(\s|~)/, $name; # ACeƌ𕪗
  ($type, $race, $level, $job, $info) = &parse_desc( $desc );
  &append( $name, $ex, $rare, $stack, $type, $race, $job, $level, $info );
}
close IN;

&sort_by_level();

# Phase2 Vsf[^\z

open IN, "$INPUT" or die "$INPUT cannot open\n";
while( <IN> ) {
  ($id,$name,$m0,$m1,$m2,$m3,$m4,$m5,$m6,$m7, $crystal,
   $sk0,$sk1,$sk2,$sk3,$sk4,$sk5,$sk6,$sk7,$sk8,$sk9,
   $min0,$min1,$min2,$min3,$min4,$min5,$min6,$min7,$min8,$min9,
   $max0,$max1,$max2,$max3,$max4,$max5,$max6,$max7,$max8,$max9,
   $hq,$guild,$rank,$desc,$ex,$rare,$stack,$dissolve) = split /,/;

  # ̃ACef[^Aނƍ͔|̃Vs(?)̓XLbv
  next if $guild < 1 || $guild == 8 || $guild == 10;

  # x: VsȂ̂ɎgpNX^ݒ肳ĂȂ
  if( $crystal < 1 || $crystal > 8 ) {
    warn "$id $name unspecified crystal\n";
    next;
  }

  $guild-- if $guild > 7;
  $guild--;   # 0:b ... 7:
  $crystal--; # 0:
  $rank--;    # 0:fl

  # x: Vs
  #warn "using dissolve: $name / $hq / $dissolve\n" if $dissolve;

  # ĩXg
  @goods = grep $_, $name, split /<>/, $hq;
  @goods_nums = ();
  for( $i = 0; $i < @goods; $i++ ) {
    # ACeƌ𕪗
    ($n,$num) = (split( /(?:\s|~)/, $goods[$i] ), 1);
    $n =~ s/^\s*(.*)\s*$/$1/;
    $num = canonicalize( $num );

    $goods[$i] = $n;
    push @goods_nums, $num;
  }

  # fނ̃Xg
  @materials = grep $_, $m0, $m1, $m2, $m3, $m4, $m5, $m6, $m7;
  unless( @materials ) {
    # x: VsȂ̂ɑfނ̃Xgݒ肳ĂȂ
    warn "$id $name has no material list\n";
    next;
  }

  # ɕKvȃXL
  @sk = ($sk0,$sk1,$sk2,$sk3,$sk4,$sk5,$sk6,$sk8);
  @min = ($min0,$min1,$min2,$min3,$min4,$min5,$min6,$min8);
  @max = ($max0,$max1,$max2,$max3,$max4,$max5,$max6,$max8);

  @skill = ();
  $guess = 0;
  for( $i = 0; $i < 8; $i++ ) {
    $min = $min[$i] =~ /^(\d+)$/ ? $1 : -1;
    $max = $max[$i] =~ /^(\d+)$/ ? $1 : -1;

    if( $i == $guild ) {
      # CXL

      # tO
      $guess = 1 if $min < 0;

      if( 0 <= $rank && $rank < 99 ) {
        # N킩ĂƂ
        $min = $min >= 0 ? $min        : $rank * 10 - ($rank ? 2 : 0);
        $max = $max >  0 ? $max - $min : 31;
      } else {
        # BVŝƂ
        $min = $min >= 0 ? $min : $max >= 0 ? $max - 10 : 0;
        $max = $max >  0 ? $max - $min : 31;
      }
      warn "max skill value($max) under min value($min)\n" if $max < 0;
      warn "max skill value over 31\n" if $max >= 32;
      unshift @skill, $min;
      unshift @skill, $i << 5 | $max;

    } elsif( $sk[$i] ) {
      # TuXL
      $min = $min >= 0 ? $min : $max >= 0 ? $max : 255;
      $max = $max >= 0 ? $max - $min : 31;

      warn "max skill value over 31\n" if $max >= 32;
      push @skill, $i << 5 | $max;
      push @skill, $min;
    }
  }

<<__EOF__;
if( $goods[0] eq 'ɂ' ) {
  print "guild=$guild\n";
  print "crystal=$crystal\n";
  print "level=$min1 - $max1\n";
  print "guess=$guess\n";
}
__EOF__

  $dat = pack "cc".("c" x @skill)
              .("c2" x @materials).("c3" x @goods),
          ($guess ? 0x80 : 0) | (0x00 << 6) | $crystal,
          ((@skill / 2 - 1) << 5) | ($#goods << 3) | $#materials,
          @skill,
          map({$a = ($ITEMS{$_}[0] || &append( $_ ));
               ($a & 0xFF, $a >> 8);} @materials),
          map({$a = ($ITEMS{$_}[0] || &append( $_ ));
               ($a & 0xFF, $a >> 8, shift @goods_nums);} @goods);
  push @RECIPES, [$max[$guild], $crystal, $dat, $ITEMS{$goods[0]}[0]];
}
close IN;

# t@Co

print STDERR "$ITEM_NUM items\n";
print STDERR (@RECIPES + 0)." recipes\n";

open OUT, ">$OUTPUT" or die "$OUTPUT cannot open\n";

# wb_
print OUT pack( "cc2c2c2", $FORMAT_VERSION,
                         $DATA_VERSION & 0xFF, $DATA_VERSION >> 8,
                         $ITEM_NUM & 0xFF, $ITEM_NUM >> 8,
                         @RECIPES & 0xFF, @RECIPES >> 8 );

# ACef[^
@i = sort {$ITEMS{$a}[0] <=> $ITEMS{$b}[0];} keys %ITEMS;
print OUT $ITEMS{$_}[1] for @i;

# Vsf[^
@r = sort {$b->[0] <=> $a->[0] or $a->[1] <=> $b->[1];} @RECIPES;
print OUT $_->[2] for @r;

$c = 0;
#printf "%20s [No:%d max:%d]\n", $i[$_->[3]], $c++, $_->[0] for @r;

close OUT;

# --- Sub --------------------------------------------------------

# ڍו͂

sub parse_desc {
  my $line = canonicalize( $_[0] );
#my $flag = 1 if $line =~ /1.*356.*Lv1/;
  $line =~ /^i(.*?)j\s*(\S+)\s*(.*)/
   or $line =~ /^y(.*?)z\s*(\S+)\s*(.*)/
   or return ($TYPES{'̑'},0,0,0,($line =~ /(?:F|:)(.*)/) ? $1 : undef);

  my $type = $TYPES{$1};
  my $race;
  if( exists $RACES{$2} ) {
    $race = $RACES{$2};
    $line = $3;
  } else {
    $race = $RACES{'S'};
    $line = "$2 $3";
  }
  my ($info,$level,$jobs,$info2) = $line =~ /(.*\S)?\s*Lv(\d+)`\s*(All Jobs|\S*)\s*(.*)/i;
  $info2 and $info .= " $info2";
  $info =~ s/ǉ(F|:)/+/;
  $info =~ s/..(F|:)/*/;
#$flag and print "'$info'".length($info)."\n";
  my $job = 0;
  my $i;
  for( $i = 0; $i < @JOBS; $i++ ) {
    $job |= 1 << (15 - $i) if index( $jobs, $JOBS[$i] ) >= 0;
  }
  $job = 0xFFFF if $jobs eq "All Jobs";
  return ($type, $race, $level, $job, $info);
}

# ACef[^$ITEMSɒǉ
# ̃ACełɑ݂΂IDԂ
# łȂΐVKɊ蓖ĂꂽIDԂ

sub append {
  my ($n, $ex, $rare, $stack, $type, $race, $job, $level, $info) = @_;

  return 0 if length $n == 0 || $n eq 'Ȃ' || $n eq '' || $n eq '-' || $n eq 'x';

  print STDERR "unknown category: $n\n" unless $type;
  if( $ITEMS{$n}[0] ) {
    #print STDERR "already exists: $n\n";
    return $ITEMS{$n}[0];
  }
  $dat = pack "ca*cccccca*",
          length $n, $n,
          $race,
          $job & 0xFF, $job >> 8,
          ($ex ? 0x80 : 0) | ($rare ? 0x40 : 0) | ($stack ? 0x20 : 0) | $type,
          $level,
          length $info, $info;
  $ITEMS{$n} = [$ITEM_NUM + 1, $dat, $type, $level];
  ++$ITEM_NUM; # ߂l
}

# ACef[^𑕔\x̍ɕבւ
# ACeIDt̂ŃVsf[^̍쐬OɎs邱

sub sort_by_level {
  my $i = 1;
  for( sort { $ITEMS{$b}[3] <=> $ITEMS{$a}[3]
           or $ITEMS{$a}[2] <=> $ITEMS{$b}[2]
           or $a cmp $b; } keys %ITEMS ) {
    $ITEMS{$_}[0] = $i++;
  }
}

sub canonicalize {
    $_ = $_[0];
    s/P/1/g; s/Q/2/g; s/R/3/g; s/S/4/g; s/T/5/g;
    s/U/6/g; s/V/7/g; s/W/8/g; s/X/9/g; s/O/0/g;
    s/{/+/g; s/c/D/g; s/F/:/g; s/@/ /g; s/<br>/ /ig;
    s/k/L/g; s//v/g;
    $_;
}
