/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.pcx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.PixelDensity;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.formats.pcx.RleWriter;
import org.apache.commons.imaging.palette.PaletteFactory;
import org.apache.commons.imaging.palette.SimplePalette;

class PcxWriter {
    private int encoding;
    private int bitDepth = -1;
    private int planes = -1;
    private PixelDensity pixelDensity;
    private final RleWriter rleWriter;

    public PcxWriter(Map<String, Object> params) throws ImageWriteException {
        Object value;
        Map<String, Object> map = params = params == null ? new HashMap<String, Object>() : new HashMap<String, Object>(params);
        if (params.containsKey("FORMAT")) {
            params.remove("FORMAT");
        }
        this.encoding = 1;
        if (params.containsKey("PCX_COMPRESSION") && (value = params.remove("PCX_COMPRESSION")) != null) {
            if (!(value instanceof Number)) {
                throw new ImageWriteException("Invalid compression parameter: " + value);
            }
            int compression = ((Number)value).intValue();
            if (compression == 0) {
                this.encoding = 0;
            }
        }
        this.rleWriter = this.encoding == 0 ? new RleWriter(false) : new RleWriter(true);
        if (params.containsKey("PCX_BIT_DEPTH") && (value = params.remove("PCX_BIT_DEPTH")) != null) {
            if (!(value instanceof Number)) {
                throw new ImageWriteException("Invalid bit depth parameter: " + value);
            }
            this.bitDepth = ((Number)value).intValue();
        }
        if (params.containsKey("PCX_PLANES") && (value = params.remove("PCX_PLANES")) != null) {
            if (!(value instanceof Number)) {
                throw new ImageWriteException("Invalid planes parameter: " + value);
            }
            this.planes = ((Number)value).intValue();
        }
        if (params.containsKey("PIXEL_DENSITY") && (value = params.remove("PIXEL_DENSITY")) != null) {
            if (!(value instanceof PixelDensity)) {
                throw new ImageWriteException("Invalid pixel density parameter");
            }
            this.pixelDensity = (PixelDensity)value;
        }
        if (this.pixelDensity == null) {
            this.pixelDensity = PixelDensity.createFromPixelsPerInch(72.0, 72.0);
        }
        if (!params.isEmpty()) {
            String firstKey = params.keySet().iterator().next();
            throw new ImageWriteException("Unknown parameter: " + firstKey);
        }
    }

    public void writeImage(BufferedImage src, OutputStream os) throws ImageWriteException, IOException {
        PaletteFactory paletteFactory = new PaletteFactory();
        SimplePalette palette = paletteFactory.makeExactRgbPaletteSimple(src, 256);
        BinaryOutputStream bos = new BinaryOutputStream(os, ByteOrder.LITTLE_ENDIAN);
        if (palette == null || this.bitDepth == 24 || this.bitDepth == 32) {
            if (this.bitDepth == 32) {
                this.write32BppPCX(src, bos);
            } else {
                this.write24BppPCX(src, bos);
            }
        } else if (palette.length() > 16 || this.bitDepth == 8) {
            this.write256ColorPCX(src, palette, bos);
        } else if (palette.length() > 8 || this.bitDepth == 4) {
            if (this.planes == 1) {
                this.write16ColorPCXIn1Plane(src, palette, bos);
            } else {
                this.write16ColorPCXIn4Planes(src, palette, bos);
            }
        } else if (palette.length() > 2 || this.bitDepth == 3) {
            this.write8ColorPcx(src, palette, bos);
        } else {
            int rgb;
            boolean onlyBlackAndWhite = true;
            if (palette.length() >= 1 && (rgb = palette.getEntry(0)) != 0 && rgb != 0xFFFFFF) {
                onlyBlackAndWhite = false;
            }
            if (palette.length() == 2 && (rgb = palette.getEntry(1)) != 0 && rgb != 0xFFFFFF) {
                onlyBlackAndWhite = false;
            }
            if (onlyBlackAndWhite) {
                this.writeBlackAndWhitePCX(src, bos);
            } else {
                this.write8ColorPcx(src, palette, bos);
            }
        }
    }

    private void write32BppPCX(BufferedImage src, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = src.getWidth() % 2 == 0 ? src.getWidth() : src.getWidth() + 1;
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(32);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        int[] rgbs = new int[src.getWidth()];
        byte[] rgbBytes = new byte[4 * bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            src.getRGB(0, y, src.getWidth(), 1, rgbs, 0, src.getWidth());
            for (int x = 0; x < rgbs.length; ++x) {
                rgbBytes[4 * x + 0] = (byte)(rgbs[x] & 0xFF);
                rgbBytes[4 * x + 1] = (byte)(rgbs[x] >> 8 & 0xFF);
                rgbBytes[4 * x + 2] = (byte)(rgbs[x] >> 16 & 0xFF);
                rgbBytes[4 * x + 3] = 0;
            }
            this.rleWriter.write(bos, rgbBytes);
        }
        this.rleWriter.flush(bos);
    }

    private void write24BppPCX(BufferedImage src, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = src.getWidth() % 2 == 0 ? src.getWidth() : src.getWidth() + 1;
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(8);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(3);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        int[] rgbs = new int[src.getWidth()];
        byte[] rgbBytes = new byte[3 * bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            src.getRGB(0, y, src.getWidth(), 1, rgbs, 0, src.getWidth());
            for (int x = 0; x < rgbs.length; ++x) {
                rgbBytes[x] = (byte)(rgbs[x] >> 16 & 0xFF);
                rgbBytes[bytesPerLine + x] = (byte)(rgbs[x] >> 8 & 0xFF);
                rgbBytes[2 * bytesPerLine + x] = (byte)(rgbs[x] & 0xFF);
            }
            this.rleWriter.write(bos, rgbBytes);
        }
        this.rleWriter.flush(bos);
    }

    private void writeBlackAndWhitePCX(BufferedImage src, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = (src.getWidth() + 7) / 8;
        if (bytesPerLine % 2 != 0) {
            ++bytesPerLine;
        }
        bos.write(10);
        bos.write(3);
        bos.write(this.encoding);
        bos.write(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] row = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            Arrays.fill(row, (byte)0);
            for (int x = 0; x < src.getWidth(); ++x) {
                int bit;
                int rgb = 0xFFFFFF & src.getRGB(x, y);
                if (rgb == 0) {
                    bit = 0;
                } else if (rgb == 0xFFFFFF) {
                    bit = 1;
                } else {
                    throw new ImageWriteException("Pixel neither black nor white");
                }
                int n = x / 8;
                row[n] = (byte)(row[n] | bit << 7 - x % 8);
            }
            this.rleWriter.write(bos, row);
        }
        this.rleWriter.flush(bos);
    }

    private void write16ColorPCXIn1Plane(BufferedImage src, SimplePalette palette, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = (src.getWidth() + 1) / 2;
        if (bytesPerLine % 2 != 0) {
            ++bytesPerLine;
        }
        byte[] palette16 = new byte[48];
        for (int i = 0; i < 16; ++i) {
            int rgb = i < palette.length() ? palette.getEntry(i) : 0;
            palette16[3 * i + 0] = (byte)(0xFF & rgb >> 16);
            palette16[3 * i + 1] = (byte)(0xFF & rgb >> 8);
            palette16[3 * i + 2] = (byte)(0xFF & rgb);
        }
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(4);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(palette16);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] indeces = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            Arrays.fill(indeces, (byte)0);
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int index = palette.getPaletteIndex(0xFFFFFF & argb);
                int n = x / 2;
                indeces[n] = (byte)(indeces[n] | index << 4 * (1 - x % 2));
            }
            this.rleWriter.write(bos, indeces);
        }
        this.rleWriter.flush(bos);
    }

    private void write16ColorPCXIn4Planes(BufferedImage src, SimplePalette palette, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = (src.getWidth() + 7) / 8;
        if (bytesPerLine % 2 != 0) {
            ++bytesPerLine;
        }
        byte[] palette16 = new byte[48];
        for (int i = 0; i < 16; ++i) {
            int rgb = i < palette.length() ? palette.getEntry(i) : 0;
            palette16[3 * i + 0] = (byte)(0xFF & rgb >> 16);
            palette16[3 * i + 1] = (byte)(0xFF & rgb >> 8);
            palette16[3 * i + 2] = (byte)(0xFF & rgb);
        }
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(palette16);
        bos.write(0);
        bos.write(4);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] plane0 = new byte[bytesPerLine];
        byte[] plane1 = new byte[bytesPerLine];
        byte[] plane2 = new byte[bytesPerLine];
        byte[] plane3 = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            Arrays.fill(plane0, (byte)0);
            Arrays.fill(plane1, (byte)0);
            Arrays.fill(plane2, (byte)0);
            Arrays.fill(plane3, (byte)0);
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int index = palette.getPaletteIndex(0xFFFFFF & argb);
                int n = x >>> 3;
                plane0[n] = (byte)(plane0[n] | (index & 1) << 7 - (x & 7));
                int n2 = x >>> 3;
                plane1[n2] = (byte)(plane1[n2] | (index & 2) >> 1 << 7 - (x & 7));
                int n3 = x >>> 3;
                plane2[n3] = (byte)(plane2[n3] | (index & 4) >> 2 << 7 - (x & 7));
                int n4 = x >>> 3;
                plane3[n4] = (byte)(plane3[n4] | (index & 8) >> 3 << 7 - (x & 7));
            }
            this.rleWriter.write(bos, plane0);
            this.rleWriter.write(bos, plane1);
            this.rleWriter.write(bos, plane2);
            this.rleWriter.write(bos, plane3);
        }
        this.rleWriter.flush(bos);
    }

    private void write8ColorPcx(BufferedImage src, SimplePalette palette, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = (src.getWidth() + 7) / 8;
        if (bytesPerLine % 2 != 0) {
            ++bytesPerLine;
        }
        byte[] palette16 = new byte[48];
        for (int i = 0; i < 8; ++i) {
            int rgb = i < palette.length() ? palette.getEntry(i) : 0;
            palette16[3 * i + 0] = (byte)(0xFF & rgb >> 16);
            palette16[3 * i + 1] = (byte)(0xFF & rgb >> 8);
            palette16[3 * i + 2] = (byte)(0xFF & rgb);
        }
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(palette16);
        bos.write(0);
        bos.write(3);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] plane0 = new byte[bytesPerLine];
        byte[] plane1 = new byte[bytesPerLine];
        byte[] plane2 = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            Arrays.fill(plane0, (byte)0);
            Arrays.fill(plane1, (byte)0);
            Arrays.fill(plane2, (byte)0);
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int index = palette.getPaletteIndex(0xFFFFFF & argb);
                int n = x >>> 3;
                plane0[n] = (byte)(plane0[n] | (index & 1) << 7 - (x & 7));
                int n2 = x >>> 3;
                plane1[n2] = (byte)(plane1[n2] | (index & 2) >> 1 << 7 - (x & 7));
                int n3 = x >>> 3;
                plane2[n3] = (byte)(plane2[n3] | (index & 4) >> 2 << 7 - (x & 7));
            }
            this.rleWriter.write(bos, plane0);
            this.rleWriter.write(bos, plane1);
            this.rleWriter.write(bos, plane2);
        }
        this.rleWriter.flush(bos);
    }

    private void write256ColorPCX(BufferedImage src, SimplePalette palette, BinaryOutputStream bos) throws ImageWriteException, IOException {
        int bytesPerLine = src.getWidth() % 2 == 0 ? src.getWidth() : src.getWidth() + 1;
        bos.write(10);
        bos.write(5);
        bos.write(this.encoding);
        bos.write(8);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write2Bytes(src.getWidth() - 1);
        bos.write2Bytes(src.getHeight() - 1);
        bos.write2Bytes((short)Math.round(this.pixelDensity.horizontalDensityInches()));
        bos.write2Bytes((short)Math.round(this.pixelDensity.verticalDensityInches()));
        bos.write(new byte[48]);
        bos.write(0);
        bos.write(1);
        bos.write2Bytes(bytesPerLine);
        bos.write2Bytes(1);
        bos.write2Bytes(0);
        bos.write2Bytes(0);
        bos.write(new byte[54]);
        byte[] indeces = new byte[bytesPerLine];
        for (int y = 0; y < src.getHeight(); ++y) {
            for (int x = 0; x < src.getWidth(); ++x) {
                int argb = src.getRGB(x, y);
                int index = palette.getPaletteIndex(0xFFFFFF & argb);
                indeces[x] = (byte)index;
            }
            this.rleWriter.write(bos, indeces);
        }
        this.rleWriter.flush(bos);
        bos.write(12);
        for (int i = 0; i < 256; ++i) {
            int rgb = i < palette.length() ? palette.getEntry(i) : 0;
            bos.write(rgb >> 16 & 0xFF);
            bos.write(rgb >> 8 & 0xFF);
            bos.write(rgb & 0xFF);
        }
    }
}

