/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class AppParameters
extends Properties {
    static final String FILE_PATH = "AdjustTime.ini";
    public static String GPX_GPXSPLIT = "GPX.gpxSplit";
    public static String GPX_NO_FIRST_NODE = "GPX.noFirstNode";
    public static String GPX_REUSE = "GPX.REUSE";
    public static String GPX_BASETIME = "GPX.BASETIME";
    public static String IMG_TIME = "IMG.TIME";
    public static String IMG_SOURCE_FOLDER = "IMG.SOURCE_FOLDER";
    public static String IMG_BASE_FILE = "IMG.BASE_FILE";
    public static String GPX_SOURCE_FOLDER = "GPX.SOURCE_FOLDER";
    public static String IMG_OUTPUT_FOLDER = "IMG.OUTPUT_FOLDER";
    public static String IMG_OUTPUT = "IMG.OUTPUT";
    public static String IMG_OUTPUT_ALL = "IMG.OUTPUT_ALL";
    public static String IMG_OUTPUT_EXIF = "IMG.OUTPUT_EXIF";
    public static String GPX_OUTPUT_SPEED = "GPX.OUTPUT_SPEED";
    public static String GPX_OVERWRITE_MAGVAR = "GPX.OVERWRITE_MAGVAR";
    public static String GPX_OUTPUT_WPT = "GPX.OUTPUT_WPT";
    File file;

    public AppParameters() throws FileNotFoundException, IOException {
        this.file = new File(FILE_PATH);
        this.syncFile();
    }

    public AppParameters(Properties defaults) throws FileNotFoundException, IOException {
        super(defaults);
        this.file = new File(FILE_PATH);
        this.syncFile();
    }

    public AppParameters(String iniFileName) throws FileNotFoundException, IOException {
        this.file = new File(iniFileName);
        this.syncFile();
    }

    private void syncFile() throws FileNotFoundException, IOException {
        boolean update = false;
        if (this.file.exists()) {
            this.load(new FileInputStream(this.file));
        } else {
            update = true;
        }
        String valueStr = this.getProperty(IMG_SOURCE_FOLDER);
        if (valueStr == null) {
            update = true;
            this.setProperty(IMG_SOURCE_FOLDER, new File(".").getAbsolutePath());
        }
        if ((valueStr = this.getProperty(GPX_SOURCE_FOLDER)) == null) {
            update = true;
            this.setProperty(GPX_SOURCE_FOLDER, new File(".").getAbsolutePath());
        }
        if ((valueStr = this.getProperty(IMG_BASE_FILE)) == null) {
            update = true;
            this.setProperty(IMG_BASE_FILE, "");
        }
        if ((valueStr = this.getProperty(IMG_OUTPUT_FOLDER)) == null) {
            update = true;
            this.setProperty(IMG_OUTPUT_FOLDER, new File(".").getAbsolutePath());
        }
        if ((valueStr = this.getProperty(IMG_OUTPUT)) == null) {
            update = true;
            valueStr = String.valueOf(true);
        }
        this.setProperty(IMG_OUTPUT, String.valueOf(valueStr));
        valueStr = this.getProperty(IMG_OUTPUT_ALL);
        if (valueStr == null) {
            update = true;
            valueStr = String.valueOf(false);
        }
        this.setProperty(IMG_OUTPUT_ALL, String.valueOf(valueStr));
        valueStr = this.getProperty(IMG_OUTPUT_EXIF);
        if (valueStr == null) {
            update = true;
            valueStr = String.valueOf(true);
        }
        this.setProperty(IMG_OUTPUT_EXIF, String.valueOf(valueStr));
        valueStr = this.getProperty(GPX_GPXSPLIT);
        if (valueStr == null) {
            update = true;
            this.setProperty(GPX_GPXSPLIT, String.valueOf(true));
        }
        if ((valueStr = this.getProperty(GPX_NO_FIRST_NODE)) == null) {
            update = true;
            this.setProperty(GPX_NO_FIRST_NODE, String.valueOf(true));
        }
        if ((valueStr = this.getProperty(GPX_OUTPUT_WPT)) == null) {
            update = true;
            this.setProperty(GPX_OUTPUT_WPT, String.valueOf(false));
        }
        if ((valueStr = this.getProperty(GPX_OVERWRITE_MAGVAR)) == null) {
            update = true;
            this.setProperty(GPX_OVERWRITE_MAGVAR, String.valueOf(false));
        }
        if ((valueStr = this.getProperty(GPX_OUTPUT_SPEED)) == null) {
            update = true;
            this.setProperty(GPX_OUTPUT_SPEED, String.valueOf(false));
        }
        if ((valueStr = this.getProperty(GPX_REUSE)) == null) {
            update = true;
            this.setProperty(GPX_REUSE, String.valueOf(false));
        }
        if ((valueStr = this.getProperty(GPX_BASETIME)) == null) {
            update = true;
            this.setProperty(GPX_BASETIME, "FILE_UPDATE");
        }
        if (update) {
            this.store(new FileOutputStream(this.file), "defuilt settings");
        }
    }

    public void store() throws FileNotFoundException, IOException {
        this.store(new FileOutputStream(this.file), "by AdjustTime");
    }
}

