/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Restamp
extends Thread {
    public Exception ex = null;
    protected static final String LOGGING_PROPERTIES_DATA = "handlers=java.util.logging.ConsoleHandler\n.level=FINEST\njava.util.logging.ConsoleHandler.level=INFO\njava.util.logging.ConsoleHandler.formatter=osm.jp.gpx.YuuLogFormatter";
    public static final Logger LOGGER;
    public File imgDir;
    public Date baseTime1;
    public Date baseTime2;
    public int bCount1 = 0;
    public int bCount2 = 0;
    public long span = 0L;
    public ArrayList<File> jpgFiles = new ArrayList();
    public static ResourceBundle i18n;

    public static void main(String[] argv) throws Exception {
        if (argv.length < 5) {
            System.out.println("java Restamp <imgDir> <baseFile1> <timeStr1> <baseFile2> <timeStr2>");
            return;
        }
        File imgDir = new File(argv[0]);
        if (!imgDir.exists()) {
            System.out.println(i18n.getString("msg.200"));
            return;
        }
        if (!imgDir.isDirectory()) {
            System.out.println(i18n.getString("msg.210"));
            return;
        }
        File baseFile1 = new File(imgDir, argv[1]);
        if (!baseFile1.exists()) {
            System.out.println(i18n.getString("msg.220"));
            return;
        }
        if (!baseFile1.isFile()) {
            System.out.println(i18n.getString("msg.230"));
            return;
        }
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss");
        Date baseTime1 = df1.parse(argv[2]);
        File baseFile2 = new File(imgDir, argv[3]);
        if (!baseFile2.exists()) {
            System.out.println(i18n.getString("msg.240"));
            return;
        }
        if (!baseFile2.isFile()) {
            System.out.println(i18n.getString("msg.250"));
            return;
        }
        SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd'_'HH:mm:ss");
        Date baseTime2 = df2.parse(argv[4]);
        Restamp obj = new Restamp();
        obj.setUp(imgDir, baseFile1, baseTime1, baseFile2, baseTime2);
    }

    public void setUp(File imgDir, File baseFile1, Date baseTime1, File baseFile2, Date baseTime2) throws Exception {
        File[] files = imgDir.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return file1.getName().compareTo(file2.getName());
            }
        });
        this.bCount1 = 0;
        this.bCount2 = 0;
        boolean base1 = false;
        boolean base2 = false;
        for (File file : files) {
            String filename;
            if (!file.isFile() || !(filename = file.getName().toUpperCase()).toUpperCase().endsWith(".JPG")) continue;
            this.jpgFiles.add(file);
            this.bCount1 += base1 ? 0 : 1;
            this.bCount2 += base2 ? 0 : 1;
            if (file.getName().equals(baseFile1.getName())) {
                base1 = true;
            }
            if (!file.getName().equals(baseFile2.getName())) continue;
            base2 = true;
        }
        try {
            long span = baseTime2.getTime() - baseTime1.getTime();
            span /= (long)(this.bCount2 - this.bCount1);
            int i = 0;
            for (File jpgFile : this.jpgFiles) {
                long deltaMsec = (long)(i - this.bCount1) * span;
                ++i;
                Calendar cal = Calendar.getInstance();
                cal.setTime(baseTime1);
                cal.add(14, (int)deltaMsec);
                jpgFile.setLastModified(cal.getTimeInMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.ex = new Exception(e);
        }
    }

    public static boolean checkFile(String name) {
        return name != null && name.toUpperCase().endsWith(".JPG");
    }

    static {
        String str;
        LOGGER = Logger.getLogger("CommandLogging");
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(LOGGING_PROPERTIES_DATA.getBytes("UTF-8"));
            try {
                LogManager.getLogManager().readConfiguration(inStream);
                LOGGER.config("LoggerSettings: LogManager setuped.");
            }
            catch (IOException e) {
                String str2 = "LoggerSettings: Exception occered:" + e.toString();
                LOGGER.warning(str2);
            }
        }
        catch (UnsupportedEncodingException e) {
            str = "LoggerSettings: Not supported 'UTF-8' encoding: " + e.toString();
            LOGGER.severe(str);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                str = "LoggerSettings: Exception occored: " + e.toString();
                LOGGER.warning(str);
            }
        }
        i18n = ResourceBundle.getBundle("i18n");
    }

    class JpegFileFilter
    implements FilenameFilter {
        JpegFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().matches(".*\\.JPG$");
        }
    }

    static class FileSort
    implements Comparator<File> {
        FileSort() {
        }

        @Override
        public int compare(File src, File target) {
            int diff = src.getName().compareTo(target.getName());
            return diff;
        }
    }
}

