/*
 * Decompiled with CFR 0.152.
 */
package osm.jp.gpx;

import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import osm.jp.gpx.ImportPicture;

public class TagTrkpt {
    public Element trkpt = null;
    public Double lat = null;
    public Double lon = null;
    public String eleStr = null;
    public Date time = null;
    public String magvarStr = null;
    public String speedStr = null;

    public TagTrkpt(Element trkpt) {
        this.trkpt = (Element)trkpt.cloneNode(true);
        NamedNodeMap nodeMap = trkpt.getAttributes();
        block22: for (int j = 0; j < nodeMap.getLength(); ++j) {
            switch (nodeMap.item(j).getNodeName()) {
                case "lat": {
                    String latStr = nodeMap.item(j).getNodeValue();
                    this.lat = new Double(latStr);
                    continue block22;
                }
                case "lon": {
                    String lonStr = nodeMap.item(j).getNodeValue();
                    this.lon = new Double(lonStr);
                }
            }
        }
        NodeList nodes1 = trkpt.getChildNodes();
        block23: for (int i1 = 0; i1 < nodes1.getLength(); ++i1) {
            Node node1 = nodes1.item(i1);
            NodeList nodes2 = node1.getChildNodes();
            switch (node1.getNodeName()) {
                case "ele": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        this.eleStr = node2.getNodeValue();
                    }
                    continue block23;
                }
                case "time": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        try {
                            this.time = ImportPicture.toUTCDate(node2.getNodeValue());
                            continue;
                        }
                        catch (ParseException e) {
                            this.time = null;
                        }
                    }
                    continue block23;
                }
                case "magvar": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        this.magvarStr = node2.getNodeValue();
                    }
                    continue block23;
                }
                case "speed": {
                    Node node2;
                    int i2;
                    for (i2 = 0; i2 < nodes2.getLength(); ++i2) {
                        node2 = nodes2.item(i2);
                        if (node2 == null || node2.getNodeType() != 3) continue;
                        this.speedStr = node2.getNodeValue();
                    }
                    continue block23;
                }
            }
        }
    }

    public void removeElement(String eleName) {
        for (Node child = this.trkpt.getFirstChild(); child != null; child = child.getNextSibling()) {
            NodeList nodeList = child.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node grandChild = child.getChildNodes().item(i);
                if (!grandChild.getNodeName().equals(eleName)) continue;
                child.removeChild(grandChild);
            }
        }
    }

    public void appendElement(String eleName, String valueStr) {
        Document doc = this.trkpt.getOwnerDocument();
        Element newElement = doc.createElement(eleName);
        newElement.setTextContent(valueStr);
        this.trkpt.appendChild(newElement);
    }
}

