<?php
/**
 * Planprice
 * 
 * プラン別料金設定
 * 
 */
require_once (dirname(__FILE__) . "/ADMIN_Controller.php");

class Planprice extends ADMIN_Controller {

    function Planprice()
    {
        parent::ADMIN_Controller();
        $this->load->helper(array('form', 'url'));
        $this->load->model('User_model');
        if ($this->User_model->isAdmin() != true)
        {
            redirect('admin/login/index');
        }
    }
    
    public function index()
    {
        $query = $this->db->get('plans');
        foreach ($query->result() as $row)
        {
            //var_dump($row);
            echo '<a href="http://localhost/ci-hotel/admin/planprice/set/' . $row->planid . '">';
            echo $row->plan_name;
            echo '</a>' . "<br />\n";
        }
    }
    
    public function set($planid)
    {
        $this->load->helper(array('form', 'url'));
        
        $data = array();
        $data['planid'] = $planid;
        $this->load->vars($data);
        
        $this->load->library('form_validation');
        
        $this->form_validation->set_rules('a_basic_price' , 'A日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_basic_price' , 'B日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_basic_price' , 'C日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_basic_price' , 'D日程 基本料金' , 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child1_price', 'A日程 子供1料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child1_price', 'B日程 子供1料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child1_price', 'C日程 子供1料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child1_price', 'D日程 子供1料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child2_price', 'A日程 子供2料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child2_price', 'B日程 子供2料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child2_price', 'C日程 子供2料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child2_price', 'D日程 子供2料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child3_price', 'A日程 子供3料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child3_price', 'B日程 子供3料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child3_price', 'C日程 子供3料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child3_price', 'D日程 子供3料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('a_child4_price', 'A日程 子供4料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('b_child4_price', 'B日程 子供4料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('c_child4_price', 'C日程 子供4料金', 'required|integer|trim|xss_clean');
        $this->form_validation->set_rules('d_child4_price', 'D日程 子供4料金', 'required|integer|trim|xss_clean');
        
        // 
        if (!$this->input->post('mysubmit'))
        {
            $this->db->where('plans.planid', $planid);
            $this->db->select('*');
            $this->db->from('plans');
            $this->db->join('planprice', 'planprice.planid = plans.planid');
            $query = $this->db->get();
            
            if ($query->num_rows() > 0)
            {
                $data = $query->row_array();
                $this->load->vars($data);
            }
            
            $this->load->view('admin/planprice/set');
            return;
        }
        
        if ($this->form_validation->run() == FALSE)
        {
            $this->load->view('admin/planprice/set');
            return;
        }
        else
        {
            log_message('info', 'bbbbbb');
            
            $a_basic_price  = set_value('a_basic_price');
            $b_basic_price  = set_value('b_basic_price');
            $c_basic_price  = set_value('c_basic_price');
            $d_basic_price  = set_value('d_basic_price');
            $a_child1_price = set_value('a_child1_price');
            $b_child1_price = set_value('b_child1_price');
            $c_child1_price = set_value('c_child1_price');
            $d_child1_price = set_value('d_child1_price');
            $a_child2_price = set_value('a_child2_price');
            $b_child2_price = set_value('b_child2_price');
            $c_child2_price = set_value('c_child2_price');
            $d_child2_price = set_value('d_child2_price');
            $a_child3_price = set_value('a_child3_price');
            $b_child3_price = set_value('b_child3_price');
            $c_child3_price = set_value('c_child3_price');
            $d_child3_price = set_value('d_child3_price');
            $a_child4_price = set_value('a_child4_price');
            $b_child4_price = set_value('b_child4_price');
            $c_child4_price = set_value('c_child4_price');
            $d_child4_price = set_value('d_child4_price');
            
            $query = $this->db->get_where('planprice', array('planid' => $planid));
            if ($query->num_rows() > 0)
            {
                $data = array(
                    'a_basic_price' => $a_basic_price,
                    'b_basic_price' => $b_basic_price,
                    'c_basic_price' => $c_basic_price,
                    'd_basic_price' => $d_basic_price,
                    'a_child1_price' => $a_child1_price,
                    'b_child1_price' => $b_child1_price,
                    'c_child1_price' => $c_child1_price,
                    'd_child1_price' => $d_child1_price,
                    'a_child2_price' => $a_child2_price,
                    'b_child2_price' => $b_child2_price,
                    'c_child2_price' => $c_child2_price,
                    'd_child2_price' => $d_child2_price,
                    'a_child3_price' => $a_child3_price,
                    'b_child3_price' => $b_child3_price,
                    'c_child3_price' => $c_child3_price,
                    'd_child3_price' => $d_child3_price,
                    'a_child4_price' => $a_child4_price,
                    'b_child4_price' => $b_child4_price,
                    'c_child4_price' => $c_child4_price,
                    'd_child4_price' => $d_child4_price,
                    );
                $this->db->where('planid', $planid);
                $this->db->update('planprice', $data);
            }
            else
            {
                $data = array(
                    'planid' => intval($planid),
                    'a_basic_price' => $a_basic_price,
                    'b_basic_price' => $b_basic_price,
                    'c_basic_price' => $c_basic_price,
                    'd_basic_price' => $d_basic_price,
                    'a_child1_price' => $a_child1_price,
                    'b_child1_price' => $b_child1_price,
                    'c_child1_price' => $c_child1_price,
                    'd_child1_price' => $d_child1_price,
                    'a_child2_price' => $a_child2_price,
                    'b_child2_price' => $b_child2_price,
                    'c_child2_price' => $c_child2_price,
                    'd_child2_price' => $d_child2_price,
                    'a_child3_price' => $a_child3_price,
                    'b_child3_price' => $b_child3_price,
                    'c_child3_price' => $c_child3_price,
                    'd_child3_price' => $d_child3_price,
                    'a_child4_price' => $a_child4_price,
                    'b_child4_price' => $b_child4_price,
                    'c_child4_price' => $c_child4_price,
                    'd_child4_price' => $d_child4_price,
                    );
                $this->db->insert('planprice', $data); 
            }
            $this->load->view('admin/planprice/set');
            return;
        }
    }
}
