package jp.sourceforge.functional;

import jp.sourceforge.functional.converter.ConverterMaker;
import jp.sourceforge.functional.converter.UnchangeConverter;
import jp.sourceforge.functional.pair.Pair;

public abstract class BinaryVisitor<T1, T2> extends
		UnaryVisitor<Pair<? extends T1, ? extends T2>> {

	public abstract void visit(T1 first, T2 second);

	@Override
	public void visit(Pair<? extends T1, ? extends T2> pair) {
		visit(pair.first, pair.second);
	}

	public UnaryVisitor<T2> bindFirst(final T1 first) {
		return new UnaryVisitor<T2>() {
			@Override
			public void visit(T2 second) {
				BinaryVisitor.this.visit(first, second);
			}
		};
	}

	public UnaryVisitor<T1> bindSecond(final T2 second) {
		return new UnaryVisitor<T1>() {
			@Override
			public void visit(T1 first) {
				BinaryVisitor.this.visit(first, second);
			}
		};
	}

	public UnaryConverter<T1, ? extends UnaryVisitor<T2>> firstBinder() {
		return new ConverterMaker<T1, T2, Void, UnaryVisitor<T2>>() {
			@Override
			public UnaryVisitor<T2> convert(T1 first) {
				return bindFirst(first);
			}
		};
	}

	public UnaryConverter<T2, ? extends UnaryVisitor<T1>> secondBinder() {
		return new ConverterMaker<T2, T1, Void, UnaryVisitor<T1>>() {
			@Override
			public UnaryVisitor<T1> convert(T2 second) {
				return bindSecond(second);
			}
		};
	}

	public <S1, S2> BinaryVisitor<S1, S2> arrange(
			final Converter<? super S1, ? extends T1> first_converter,
			final Converter<? super S2, ? extends T2> second_converter) {
		return new BinaryVisitor<S1, S2>() {
			@Override
			public void visit(S1 first, S2 second) {
				BinaryVisitor.this.visit(first_converter.convert(first),
						second_converter.convert(second));
			}
		};
	}

	public <S> BinaryVisitor<S, T2> arrangeFirst(
			final Converter<? super S, ? extends T1> converter) {
		return arrange(converter, UnchangeConverter.<T2> getInstance());
	}

	public <S> BinaryVisitor<T1, S> arrangeSecond(
			final Converter<? super S, ? extends T2> converter) {
		return arrange(UnchangeConverter.<T1> getInstance(), converter);
	}
}
