package jp.sourceforge.functional;

/**
 * 引数を取らずに何らかの値を返すファンクタ。
 * 
 * @author Fujii Kenichi
 * 
 * @param <R>
 *            戻り値の型
 */
public interface Getter<R> {
	/**
	 * <p>
	 * 何らかの値を返す。
	 * </p>
	 * <p>
	 * <code>get</code>と言う名前だが、新しく生成されたオブジェクトを返す （通常なら<code>make</code>や
	 * <code>create</code> と名付けるような動作をする） 場合もあるので、留意すること。
	 * </p>
	 * 
	 * @return 何かの値
	 */
	R get();
}
