package jp.sourceforge.functional;

import jp.sourceforge.functional.util.ClassifyUtil;

public abstract class NullaryClassifier extends NullaryConverter<Boolean>
		implements Classifier<Object> {

	public static final NullaryClassifier TRUE = new NullaryClassifier() {
		@Override
		public boolean conclude() {
			return true;
		}
	};
	public static final NullaryClassifier FALSE = new NullaryClassifier() {
		@Override
		public boolean conclude() {
			return false;
		}
	};

	public Classifier<Object> negative() {
		return ClassifyUtil.negative(this);
	}

	public abstract boolean conclude();

	@Override
	public final boolean classify(Object object) {
		return conclude();
	}

	@Override
	public Boolean convert(Object source) {
		return conclude();
	}

	@Override
	public Boolean get() {
		return conclude();
	}
}
